package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletStatusBuilder extends KameletStatusFluentImpl<KameletStatusBuilder> implements VisitableBuilder<KameletStatus,KameletStatusBuilder> {

    KameletStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KameletStatusBuilder() {
        this(true);
    }

    public KameletStatusBuilder(Boolean validationEnabled) {
        this(new KameletStatus(), validationEnabled);
    }

    public KameletStatusBuilder(KameletStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletStatusBuilder(KameletStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletStatus(), validationEnabled);
    }

    public KameletStatusBuilder(KameletStatusFluent<?> fluent,KameletStatus instance) {
        this(fluent, instance, true);
    }

    public KameletStatusBuilder(KameletStatusFluent<?> fluent,KameletStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withProperties(instance.getProperties()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletStatusBuilder(KameletStatus instance) {
        this(instance,true);
    }

    public KameletStatusBuilder(KameletStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
        this.withProperties(instance.getProperties()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletStatus build() {
        EditableKameletStatus buildable = new EditableKameletStatus(fluent.getConditions(),fluent.getPhase(),fluent.getProperties());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletStatusBuilder that = (KameletStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
