package io.fabric8.camelk.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.camelk.v1.SourceSpec;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class KameletSpecFluentImpl<A extends KameletSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KameletSpecFluent<A> {

    private AuthorizationSpecBuilder authorization;
    private JSONSchemaProps definition;
    private List<String> dependencies;
    private JsonNode flow;
    private List<SourceSpec> sources;
    private Map<String,EventTypeSpec> types;

    public KameletSpecFluentImpl() {
    }

    public KameletSpecFluentImpl(KameletSpec instance) {
        this.withAuthorization(instance.getAuthorization()); 
        this.withDefinition(instance.getDefinition()); 
        this.withDependencies(instance.getDependencies()); 
        this.withFlow(instance.getFlow()); 
        this.withSources(instance.getSources()); 
        this.withTypes(instance.getTypes()); 
    }

    
/**
 * This method has been deprecated, please use method buildAuthorization instead.
 * @return The buildable object.
 */
@Deprecated public AuthorizationSpec getAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public AuthorizationSpec buildAuthorization() {
        return this.authorization!=null?this.authorization.build():null;
    }

    public A withAuthorization(AuthorizationSpec authorization) {
        _visitables.get("authorization").remove(this.authorization);
        if (authorization!=null){ this.authorization= new AuthorizationSpecBuilder(authorization); _visitables.get("authorization").add(this.authorization);} return (A) this;
    }

    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    public KameletSpecFluent.AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNestedImpl();
    }

    public KameletSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(AuthorizationSpec item) {
        return new AuthorizationNestedImpl(item);
    }

    public KameletSpecFluent.AuthorizationNested<A> editAuthorization() {
        return withNewAuthorizationLike(getAuthorization());
    }

    public KameletSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
        return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new AuthorizationSpecBuilder().build());
    }

    public KameletSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(AuthorizationSpec item) {
        return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
    }

    public JSONSchemaProps getDefinition() {
        return this.definition;
    }

    public A withDefinition(JSONSchemaProps definition) {
        this.definition=definition; return (A) this;
    }

    public Boolean hasDefinition() {
        return this.definition != null;
    }

    public A addToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(String... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(String... items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<String>(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(StringBuilder arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(int[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(char[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(StringBuffer arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(byte[] arg1,int arg2) {
        return (A)addToDependencies(new String(arg1, arg2));
    }

    public A addNewDependency(byte[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(char[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToDependencies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewDependency(String arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public JsonNode getFlow() {
        return this.flow;
    }

    public A withFlow(JsonNode flow) {
        this.flow=flow; return (A) this;
    }

    public Boolean hasFlow() {
        return this.flow != null;
    }

    public A addToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
        this.sources.add(index, item);
        return (A)this;
    }

    public A setToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
        this.sources.set(index, item); return (A)this;
    }

    public A addToSources(SourceSpec... items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
        for (SourceSpec item : items) {this.sources.add(item);} return (A)this;
    }

    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
        for (SourceSpec item : items) {this.sources.add(item);} return (A)this;
    }

    public A removeFromSources(SourceSpec... items) {
        for (SourceSpec item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
    }

    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
    }

    public List<SourceSpec> getSources() {
        return this.sources;
    }

    public SourceSpec getSource(int index) {
        return this.sources.get(index);
    }

    public SourceSpec getFirstSource() {
        return this.sources.get(0);
    }

    public SourceSpec getLastSource() {
        return this.sources.get(sources.size() - 1);
    }

    public SourceSpec getMatchingSource(Predicate<SourceSpec> predicate) {
        for (SourceSpec item: sources) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSource(Predicate<SourceSpec> predicate) {
        for (SourceSpec item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new ArrayList<SourceSpec>(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(SourceSpec... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
    }

    public Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public A addToTypes(String key,EventTypeSpec value) {
        if(this.types == null && key != null && value != null) { this.types = new LinkedHashMap<String,EventTypeSpec>(); }
        if(key != null && value != null) {this.types.put(key, value);} return (A)this;
    }

    public A addToTypes(Map<String,EventTypeSpec> map) {
        if(this.types == null && map != null) { this.types = new LinkedHashMap<String,EventTypeSpec>(); }
        if(map != null) { this.types.putAll(map);} return (A)this;
    }

    public A removeFromTypes(String key) {
        if(this.types == null) { return (A) this; }
        if(key != null && this.types != null) {this.types.remove(key);} return (A)this;
    }

    public A removeFromTypes(Map<String,EventTypeSpec> map) {
        if(this.types == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.types != null){this.types.remove(key);}}} return (A)this;
    }

    public Map<String,EventTypeSpec> getTypes() {
        return this.types;
    }

    public <K extends Object,V extends Object>A withTypes(Map<String,EventTypeSpec> types) {
        if (types == null) { this.types =  null;} else {this.types = new LinkedHashMap<String,EventTypeSpec>(types);} return (A) this;
    }

    public Boolean hasTypes() {
        return this.types != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KameletSpecFluentImpl that = (KameletSpecFluentImpl) o;
        if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
        if (definition != null ? !definition.equals(that.definition) :that.definition != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (flow != null ? !flow.equals(that.flow) :that.flow != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        if (types != null ? !types.equals(that.types) :that.types != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(authorization,  definition,  dependencies,  flow,  sources,  types,  super.hashCode());
    }

    public class AuthorizationNestedImpl<N> extends AuthorizationSpecFluentImpl<KameletSpecFluent.AuthorizationNested<N>> implements KameletSpecFluent.AuthorizationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthorizationSpecBuilder builder;

            AuthorizationNestedImpl(AuthorizationSpec item) {
                this.builder = new AuthorizationSpecBuilder(this, item);
                        
            }

            AuthorizationNestedImpl() {
                this.builder = new AuthorizationSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KameletSpecFluentImpl.this.withAuthorization(builder.build());
            }

            public N endAuthorization() {
                return and();
            }
    }


}
