package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletPropertyBuilder extends KameletPropertyFluentImpl<KameletPropertyBuilder> implements VisitableBuilder<KameletProperty,KameletPropertyBuilder> {

    KameletPropertyFluent<?> fluent;
    Boolean validationEnabled;

    public KameletPropertyBuilder() {
        this(true);
    }

    public KameletPropertyBuilder(Boolean validationEnabled) {
        this(new KameletProperty(), validationEnabled);
    }

    public KameletPropertyBuilder(KameletPropertyFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletProperty(), validationEnabled);
    }

    public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,KameletProperty instance) {
        this(fluent, instance, true);
    }

    public KameletPropertyBuilder(KameletPropertyFluent<?> fluent,KameletProperty instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefault(instance.getDefault()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletPropertyBuilder(KameletProperty instance) {
        this(instance,true);
    }

    public KameletPropertyBuilder(KameletProperty instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefault(instance.getDefault()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletProperty build() {
        EditableKameletProperty buildable = new EditableKameletProperty(fluent.getDefault(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletPropertyBuilder that = (KameletPropertyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
