package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletListBuilder extends KameletListFluentImpl<KameletListBuilder> implements VisitableBuilder<KameletList,KameletListBuilder> {

    KameletListFluent<?> fluent;
    Boolean validationEnabled;

    public KameletListBuilder() {
        this(true);
    }

    public KameletListBuilder(Boolean validationEnabled) {
        this(new KameletList(), validationEnabled);
    }

    public KameletListBuilder(KameletListFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletListBuilder(KameletListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletList(), validationEnabled);
    }

    public KameletListBuilder(KameletListFluent<?> fluent,KameletList instance) {
        this(fluent, instance, true);
    }

    public KameletListBuilder(KameletListFluent<?> fluent,KameletList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletListBuilder(KameletList instance) {
        this(instance,true);
    }

    public KameletListBuilder(KameletList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletList build() {
        EditableKameletList buildable = new EditableKameletList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletListBuilder that = (KameletListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
