package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBindingBuilder extends KameletBindingFluentImpl<KameletBindingBuilder> implements VisitableBuilder<KameletBinding,KameletBindingBuilder> {

    KameletBindingFluent<?> fluent;
    Boolean validationEnabled;

    public KameletBindingBuilder() {
        this(true);
    }

    public KameletBindingBuilder(Boolean validationEnabled) {
        this(new KameletBinding(), validationEnabled);
    }

    public KameletBindingBuilder(KameletBindingFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletBindingBuilder(KameletBindingFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletBinding(), validationEnabled);
    }

    public KameletBindingBuilder(KameletBindingFluent<?> fluent,KameletBinding instance) {
        this(fluent, instance, true);
    }

    public KameletBindingBuilder(KameletBindingFluent<?> fluent,KameletBinding instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletBindingBuilder(KameletBinding instance) {
        this(instance,true);
    }

    public KameletBindingBuilder(KameletBinding instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletBinding build() {
        EditableKameletBinding buildable = new EditableKameletBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletBindingBuilder that = (KameletBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
