package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthorizationSpecBuilder extends AuthorizationSpecFluentImpl<AuthorizationSpecBuilder> implements VisitableBuilder<AuthorizationSpec,AuthorizationSpecBuilder> {

    AuthorizationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AuthorizationSpecBuilder() {
        this(true);
    }

    public AuthorizationSpecBuilder(Boolean validationEnabled) {
        this(new AuthorizationSpec(), validationEnabled);
    }

    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AuthorizationSpec(), validationEnabled);
    }

    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,AuthorizationSpec instance) {
        this(fluent, instance, true);
    }

    public AuthorizationSpecBuilder(AuthorizationSpecFluent<?> fluent,AuthorizationSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public AuthorizationSpecBuilder(AuthorizationSpec instance) {
        this(instance,true);
    }

    public AuthorizationSpecBuilder(AuthorizationSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableAuthorizationSpec build() {
        EditableAuthorizationSpec buildable = new EditableAuthorizationSpec();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuthorizationSpecBuilder that = (AuthorizationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
