package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBuilder extends KameletFluentImpl<KameletBuilder> implements VisitableBuilder<Kamelet,KameletBuilder> {

    KameletFluent<?> fluent;
    Boolean validationEnabled;

    public KameletBuilder() {
        this(true);
    }

    public KameletBuilder(Boolean validationEnabled) {
        this(new Kamelet(), validationEnabled);
    }

    public KameletBuilder(KameletFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletBuilder(KameletFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Kamelet(), validationEnabled);
    }

    public KameletBuilder(KameletFluent<?> fluent,Kamelet instance) {
        this(fluent, instance, true);
    }

    public KameletBuilder(KameletFluent<?> fluent,Kamelet instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletBuilder(Kamelet instance) {
        this(instance,true);
    }

    public KameletBuilder(Kamelet instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKamelet build() {
        EditableKamelet buildable = new EditableKamelet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletBuilder that = (KameletBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
