package io.fabric8.camelk.v1alpha1;

import io.fabric8.camelk.v1.IntegrationSpec;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBindingSpecFluentImpl<A extends KameletBindingSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KameletBindingSpecFluent<A> {

    private IntegrationSpec integration;
    private EndpointBuilder sink;
    private EndpointBuilder source;

    public KameletBindingSpecFluentImpl() {
    }

    public KameletBindingSpecFluentImpl(KameletBindingSpec instance) {
        this.withIntegration(instance.getIntegration()); 
        this.withSink(instance.getSink()); 
        this.withSource(instance.getSource()); 
    }

    public IntegrationSpec getIntegration() {
        return this.integration;
    }

    public A withIntegration(IntegrationSpec integration) {
        this.integration=integration; return (A) this;
    }

    public Boolean hasIntegration() {
        return this.integration != null;
    }

    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Endpoint getSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public Endpoint buildSink() {
        return this.sink!=null?this.sink.build():null;
    }

    public A withSink(Endpoint sink) {
        _visitables.get("sink").remove(this.sink);
        if (sink!=null){ this.sink= new EndpointBuilder(sink); _visitables.get("sink").add(this.sink);} return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public KameletBindingSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    public KameletBindingSpecFluent.SinkNested<A> withNewSinkLike(Endpoint item) {
        return new SinkNestedImpl(item);
    }

    public KameletBindingSpecFluent.SinkNested<A> editSink() {
        return withNewSinkLike(getSink());
    }

    public KameletBindingSpecFluent.SinkNested<A> editOrNewSink() {
        return withNewSinkLike(getSink() != null ? getSink(): new EndpointBuilder().build());
    }

    public KameletBindingSpecFluent.SinkNested<A> editOrNewSinkLike(Endpoint item) {
        return withNewSinkLike(getSink() != null ? getSink(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public Endpoint getSource() {
        return this.source!=null?this.source.build():null;
    }

    public Endpoint buildSource() {
        return this.source!=null?this.source.build():null;
    }

    public A withSource(Endpoint source) {
        _visitables.get("source").remove(this.source);
        if (source!=null){ this.source= new EndpointBuilder(source); _visitables.get("source").add(this.source);} return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public KameletBindingSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    public KameletBindingSpecFluent.SourceNested<A> withNewSourceLike(Endpoint item) {
        return new SourceNestedImpl(item);
    }

    public KameletBindingSpecFluent.SourceNested<A> editSource() {
        return withNewSourceLike(getSource());
    }

    public KameletBindingSpecFluent.SourceNested<A> editOrNewSource() {
        return withNewSourceLike(getSource() != null ? getSource(): new EndpointBuilder().build());
    }

    public KameletBindingSpecFluent.SourceNested<A> editOrNewSourceLike(Endpoint item) {
        return withNewSourceLike(getSource() != null ? getSource(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KameletBindingSpecFluentImpl that = (KameletBindingSpecFluentImpl) o;
        if (integration != null ? !integration.equals(that.integration) :that.integration != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(integration,  sink,  source,  super.hashCode());
    }

    public class SinkNestedImpl<N> extends EndpointFluentImpl<KameletBindingSpecFluent.SinkNested<N>> implements KameletBindingSpecFluent.SinkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointBuilder builder;

            SinkNestedImpl(Endpoint item) {
                this.builder = new EndpointBuilder(this, item);
                        
            }

            SinkNestedImpl() {
                this.builder = new EndpointBuilder(this);
                        
            }

            public N and() {
                return (N) KameletBindingSpecFluentImpl.this.withSink(builder.build());
            }

            public N endSink() {
                return and();
            }
    }


    public class SourceNestedImpl<N> extends EndpointFluentImpl<KameletBindingSpecFluent.SourceNested<N>> implements KameletBindingSpecFluent.SourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointBuilder builder;

            SourceNestedImpl(Endpoint item) {
                this.builder = new EndpointBuilder(this, item);
                        
            }

            SourceNestedImpl() {
                this.builder = new EndpointBuilder(this);
                        
            }

            public N and() {
                return (N) KameletBindingSpecFluentImpl.this.withSource(builder.build());
            }

            public N endSource() {
                return and();
            }
    }


}
