package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBindingConditionBuilder extends KameletBindingConditionFluentImpl<KameletBindingConditionBuilder> implements VisitableBuilder<KameletBindingCondition,KameletBindingConditionBuilder> {

    KameletBindingConditionFluent<?> fluent;
    Boolean validationEnabled;

    public KameletBindingConditionBuilder() {
        this(true);
    }

    public KameletBindingConditionBuilder(Boolean validationEnabled) {
        this(new KameletBindingCondition(), validationEnabled);
    }

    public KameletBindingConditionBuilder(KameletBindingConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletBindingConditionBuilder(KameletBindingConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletBindingCondition(), validationEnabled);
    }

    public KameletBindingConditionBuilder(KameletBindingConditionFluent<?> fluent,KameletBindingCondition instance) {
        this(fluent, instance, true);
    }

    public KameletBindingConditionBuilder(KameletBindingConditionFluent<?> fluent,KameletBindingCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletBindingConditionBuilder(KameletBindingCondition instance) {
        this(instance,true);
    }

    public KameletBindingConditionBuilder(KameletBindingCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletBindingCondition build() {
        EditableKameletBindingCondition buildable = new EditableKameletBindingCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletBindingConditionBuilder that = (KameletBindingConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
