package io.fabric8.camelk.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

public class EndpointFluentImpl<A extends EndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EndpointFluent<A> {

    private EndpointPropertiesBuilder properties;
    private ObjectReferenceBuilder ref;
    private Map<String,EventTypeSpec> types;
    private String uri;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withProperties(instance.getProperties()); 
        this.withRef(instance.getRef()); 
        this.withTypes(instance.getTypes()); 
        this.withUri(instance.getUri()); 
    }

    
/**
 * This method has been deprecated, please use method buildProperties instead.
 * @return The buildable object.
 */
@Deprecated public EndpointProperties getProperties() {
        return this.properties!=null?this.properties.build():null;
    }

    public EndpointProperties buildProperties() {
        return this.properties!=null?this.properties.build():null;
    }

    public A withProperties(EndpointProperties properties) {
        _visitables.get("properties").remove(this.properties);
        if (properties!=null){ this.properties= new EndpointPropertiesBuilder(properties); _visitables.get("properties").add(this.properties);} return (A) this;
    }

    public Boolean hasProperties() {
        return this.properties != null;
    }

    public EndpointFluent.PropertiesNested<A> withNewProperties() {
        return new PropertiesNestedImpl();
    }

    public EndpointFluent.PropertiesNested<A> withNewPropertiesLike(EndpointProperties item) {
        return new PropertiesNestedImpl(item);
    }

    public EndpointFluent.PropertiesNested<A> editProperties() {
        return withNewPropertiesLike(getProperties());
    }

    public EndpointFluent.PropertiesNested<A> editOrNewProperties() {
        return withNewPropertiesLike(getProperties() != null ? getProperties(): new EndpointPropertiesBuilder().build());
    }

    public EndpointFluent.PropertiesNested<A> editOrNewPropertiesLike(EndpointProperties item) {
        return withNewPropertiesLike(getProperties() != null ? getProperties(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getRef() {
        return this.ref!=null?this.ref.build():null;
    }

    public ObjectReference buildRef() {
        return this.ref!=null?this.ref.build():null;
    }

    public A withRef(ObjectReference ref) {
        _visitables.get("ref").remove(this.ref);
        if (ref!=null){ this.ref= new ObjectReferenceBuilder(ref); _visitables.get("ref").add(this.ref);} return (A) this;
    }

    public Boolean hasRef() {
        return this.ref != null;
    }

    public EndpointFluent.RefNested<A> withNewRef() {
        return new RefNestedImpl();
    }

    public EndpointFluent.RefNested<A> withNewRefLike(ObjectReference item) {
        return new RefNestedImpl(item);
    }

    public EndpointFluent.RefNested<A> editRef() {
        return withNewRefLike(getRef());
    }

    public EndpointFluent.RefNested<A> editOrNewRef() {
        return withNewRefLike(getRef() != null ? getRef(): new ObjectReferenceBuilder().build());
    }

    public EndpointFluent.RefNested<A> editOrNewRefLike(ObjectReference item) {
        return withNewRefLike(getRef() != null ? getRef(): item);
    }

    public A addToTypes(String key,EventTypeSpec value) {
        if(this.types == null && key != null && value != null) { this.types = new LinkedHashMap<String,EventTypeSpec>(); }
        if(key != null && value != null) {this.types.put(key, value);} return (A)this;
    }

    public A addToTypes(Map<String,EventTypeSpec> map) {
        if(this.types == null && map != null) { this.types = new LinkedHashMap<String,EventTypeSpec>(); }
        if(map != null) { this.types.putAll(map);} return (A)this;
    }

    public A removeFromTypes(String key) {
        if(this.types == null) { return (A) this; }
        if(key != null && this.types != null) {this.types.remove(key);} return (A)this;
    }

    public A removeFromTypes(Map<String,EventTypeSpec> map) {
        if(this.types == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.types != null){this.types.remove(key);}}} return (A)this;
    }

    public Map<String,EventTypeSpec> getTypes() {
        return this.types;
    }

    public <K extends Object,V extends Object>A withTypes(Map<String,EventTypeSpec> types) {
        if (types == null) { this.types =  null;} else {this.types = new LinkedHashMap<String,EventTypeSpec>(types);} return (A) this;
    }

    public Boolean hasTypes() {
        return this.types != null;
    }

    public String getUri() {
        return this.uri;
    }

    public A withUri(String uri) {
        this.uri=uri; return (A) this;
    }

    public Boolean hasUri() {
        return this.uri != null;
    }

    public A withNewUri(StringBuilder arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(int[] arg1,int arg2,int arg3) {
        return (A)withUri(new String(arg1, arg2, arg3));
    }

    public A withNewUri(char[] arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(StringBuffer arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(byte[] arg1,int arg2) {
        return (A)withUri(new String(arg1, arg2));
    }

    public A withNewUri(byte[] arg1) {
        return (A)withUri(new String(arg1));
    }

    public A withNewUri(char[] arg1,int arg2,int arg3) {
        return (A)withUri(new String(arg1, arg2, arg3));
    }

    public A withNewUri(byte[] arg1,int arg2,int arg3) {
        return (A)withUri(new String(arg1, arg2, arg3));
    }

    public A withNewUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUri(String arg1) {
        return (A)withUri(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointFluentImpl that = (EndpointFluentImpl) o;
        if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
        if (ref != null ? !ref.equals(that.ref) :that.ref != null) return false;
        if (types != null ? !types.equals(that.types) :that.types != null) return false;
        if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(properties,  ref,  types,  uri,  super.hashCode());
    }

    public class PropertiesNestedImpl<N> extends EndpointPropertiesFluentImpl<EndpointFluent.PropertiesNested<N>> implements EndpointFluent.PropertiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointPropertiesBuilder builder;

            PropertiesNestedImpl(EndpointProperties item) {
                this.builder = new EndpointPropertiesBuilder(this, item);
                        
            }

            PropertiesNestedImpl() {
                this.builder = new EndpointPropertiesBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointFluentImpl.this.withProperties(builder.build());
            }

            public N endProperties() {
                return and();
            }
    }


    public class RefNestedImpl<N> extends ObjectReferenceFluentImpl<EndpointFluent.RefNested<N>> implements EndpointFluent.RefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectReferenceBuilder builder;

            RefNestedImpl(ObjectReference item) {
                this.builder = new ObjectReferenceBuilder(this, item);
                        
            }

            RefNestedImpl() {
                this.builder = new ObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) EndpointFluentImpl.this.withRef(builder.build());
            }

            public N endRef() {
                return and();
            }
    }


}
