package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder> {

    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() {
        this(true);
    }

    public EndpointBuilder(Boolean validationEnabled) {
        this(new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance) {
        this(fluent, instance, true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProperties(instance.getProperties()); 
        fluent.withRef(instance.getRef()); 
        fluent.withTypes(instance.getTypes()); 
        fluent.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointBuilder(Endpoint instance) {
        this(instance,true);
    }

    public EndpointBuilder(Endpoint instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withProperties(instance.getProperties()); 
        this.withRef(instance.getRef()); 
        this.withTypes(instance.getTypes()); 
        this.withUri(instance.getUri()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableEndpoint build() {
        EditableEndpoint buildable = new EditableEndpoint(fluent.getProperties(),fluent.getRef(),fluent.getTypes(),fluent.getUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointBuilder that = (EndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
