/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecFluent;
import io.fabric8.camelk.v1.ResourceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ResourceSpecBuilder
extends ResourceSpecFluentImpl<ResourceSpecBuilder>
implements VisitableBuilder<ResourceSpec, ResourceSpecBuilder> {
    ResourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceSpecBuilder() {
        this(false);
    }

    public ResourceSpecBuilder(Boolean validationEnabled) {
        this(new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceSpec(), validationEnabled);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent, ResourceSpec instance) {
        this(fluent, instance, false);
    }

    public ResourceSpecBuilder(ResourceSpecFluent<?> fluent, ResourceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCompression(instance.getCompression());
        fluent.withContent(instance.getContent());
        fluent.withContentKey(instance.getContentKey());
        fluent.withContentRef(instance.getContentRef());
        fluent.withMountPath(instance.getMountPath());
        fluent.withName(instance.getName());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ResourceSpecBuilder(ResourceSpec instance) {
        this(instance, (Boolean)false);
    }

    public ResourceSpecBuilder(ResourceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCompression(instance.getCompression());
        this.withContent(instance.getContent());
        this.withContentKey(instance.getContentKey());
        this.withContentRef(instance.getContentRef());
        this.withMountPath(instance.getMountPath());
        this.withName(instance.getName());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ResourceSpec build() {
        ResourceSpec buildable = new ResourceSpec(this.fluent.getCompression(), this.fluent.getContent(), this.fluent.getContentKey(), this.fluent.getContentRef(), this.fluent.getMountPath(), this.fluent.getName(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceSpecBuilder that = (ResourceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

