/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Capability;
import io.fabric8.camelk.v1.MavenArtifact;
import io.fabric8.camelk.v1.MavenArtifactBuilder;
import io.fabric8.camelk.v1.MavenArtifactFluentImpl;
import io.fabric8.camelk.v1.RuntimeSpec;
import io.fabric8.camelk.v1.RuntimeSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuntimeSpecFluentImpl<A extends RuntimeSpecFluent<A>>
extends BaseFluent<A>
implements RuntimeSpecFluent<A> {
    private String applicationClass;
    private Map<String, Capability> capabilities;
    private ArrayList<MavenArtifactBuilder> dependencies = new ArrayList();
    private Map<String, String> metadata;
    private String provider;
    private String version;

    public RuntimeSpecFluentImpl() {
    }

    public RuntimeSpecFluentImpl(RuntimeSpec instance) {
        if (instance != null) {
            this.withApplicationClass(instance.getApplicationClass());
            this.withCapabilities(instance.getCapabilities());
            this.withDependencies(instance.getDependencies());
            this.withMetadata(instance.getMetadata());
            this.withProvider(instance.getProvider());
            this.withVersion(instance.getVersion());
        }
    }

    @Override
    public String getApplicationClass() {
        return this.applicationClass;
    }

    @Override
    public A withApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
        return (A)this;
    }

    @Override
    public Boolean hasApplicationClass() {
        return this.applicationClass != null;
    }

    @Override
    public A addToCapabilities(String key, Capability value) {
        if (this.capabilities == null && key != null && value != null) {
            this.capabilities = new LinkedHashMap<String, Capability>();
        }
        if (key != null && value != null) {
            this.capabilities.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapabilities(Map<String, Capability> map) {
        if (this.capabilities == null && map != null) {
            this.capabilities = new LinkedHashMap<String, Capability>();
        }
        if (map != null) {
            this.capabilities.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapabilities(String key) {
        if (this.capabilities == null) {
            return (A)this;
        }
        if (key != null && this.capabilities != null) {
            this.capabilities.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapabilities(Map<String, Capability> map) {
        if (this.capabilities == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capabilities == null) continue;
                this.capabilities.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Capability> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public <K, V> A withCapabilities(Map<String, Capability> capabilities) {
        this.capabilities = capabilities == null ? null : new LinkedHashMap<String, Capability>(capabilities);
        return (A)this;
    }

    @Override
    public Boolean hasCapabilities() {
        return this.capabilities != null;
    }

    @Override
    public A addToDependencies(int index, MavenArtifact item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToDependencies(int index, MavenArtifact item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDependencies(MavenArtifact ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<MavenArtifact> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(MavenArtifact ... items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<MavenArtifact> items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)this;
        }
        Iterator<MavenArtifactBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            MavenArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MavenArtifact> getDependencies() {
        return this.dependencies != null ? RuntimeSpecFluentImpl.build(this.dependencies) : null;
    }

    @Override
    public List<MavenArtifact> buildDependencies() {
        return this.dependencies != null ? RuntimeSpecFluentImpl.build(this.dependencies) : null;
    }

    @Override
    public MavenArtifact buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    @Override
    public MavenArtifact buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    @Override
    public MavenArtifact buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    @Override
    public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<MavenArtifact> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").clear();
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList();
            for (MavenArtifact item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(MavenArtifact ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (MavenArtifact item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addNewDependency(String artifactId, String groupId, String version) {
        return this.addToDependencies(new MavenArtifact(artifactId, groupId, version));
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
        return new DependenciesNestedImpl(-1, item);
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> setNewDependencyLike(int index, MavenArtifact item) {
        return new DependenciesNestedImpl(index, item);
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public RuntimeSpecFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public A addToMetadata(String key, String value) {
        if (this.metadata == null && key != null && value != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.metadata.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToMetadata(Map<String, String> map) {
        if (this.metadata == null && map != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.metadata.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetadata(String key) {
        if (this.metadata == null) {
            return (A)this;
        }
        if (key != null && this.metadata != null) {
            this.metadata.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetadata(Map<String, String> map) {
        if (this.metadata == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metadata == null) continue;
                this.metadata.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public <K, V> A withMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : new LinkedHashMap<String, String>(metadata);
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public A withProvider(String provider) {
        this.provider = provider;
        return (A)this;
    }

    @Override
    public Boolean hasProvider() {
        return this.provider != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeSpecFluentImpl that = (RuntimeSpecFluentImpl)o;
        if (!Objects.equals(this.applicationClass, that.applicationClass)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.provider, that.provider)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.applicationClass, this.capabilities, this.dependencies, this.metadata, this.provider, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationClass != null) {
            sb.append("applicationClass:");
            sb.append(this.applicationClass + ",");
        }
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.dependencies != null) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.provider != null) {
            sb.append("provider:");
            sb.append(this.provider + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    class DependenciesNestedImpl<N>
    extends MavenArtifactFluentImpl<RuntimeSpecFluent.DependenciesNested<N>>
    implements RuntimeSpecFluent.DependenciesNested<N>,
    Nested<N> {
        MavenArtifactBuilder builder;
        int index;

        DependenciesNestedImpl(int index, MavenArtifact item) {
            this.index = index;
            this.builder = new MavenArtifactBuilder(this, item);
        }

        DependenciesNestedImpl() {
            this.index = -1;
            this.builder = new MavenArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)RuntimeSpecFluentImpl.this.setToDependencies(this.index, this.builder.build());
        }

        @Override
        public N endDependency() {
            return this.and();
        }
    }
}

