/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Integration;
import io.fabric8.camelk.v1.IntegrationFluent;
import io.fabric8.camelk.v1.IntegrationFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class IntegrationBuilder
extends IntegrationFluentImpl<IntegrationBuilder>
implements VisitableBuilder<Integration, IntegrationBuilder> {
    IntegrationFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationBuilder() {
        this(false);
    }

    public IntegrationBuilder(Boolean validationEnabled) {
        this(new Integration(), validationEnabled);
    }

    public IntegrationBuilder(IntegrationFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IntegrationBuilder(IntegrationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Integration(), validationEnabled);
    }

    public IntegrationBuilder(IntegrationFluent<?> fluent, Integration instance) {
        this(fluent, instance, false);
    }

    public IntegrationBuilder(IntegrationFluent<?> fluent, Integration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public IntegrationBuilder(Integration instance) {
        this(instance, (Boolean)false);
    }

    public IntegrationBuilder(Integration instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
        this.validationEnabled = validationEnabled;
    }

    public Integration build() {
        Integration buildable = new Integration(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }
}

