package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceSpecBuilder extends SourceSpecFluentImpl<SourceSpecBuilder> implements VisitableBuilder<SourceSpec,SourceSpecBuilder>{
  public SourceSpecBuilder() {
    this(false);
  }
  public SourceSpecBuilder(Boolean validationEnabled) {
    this(new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SourceSpec(), validationEnabled);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance) {
    this(fluent, instance, false);
  }
  public SourceSpecBuilder(SourceSpecFluent<?> fluent,SourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCompression(instance.getCompression());
      fluent.withContent(instance.getContent());
      fluent.withContentKey(instance.getContentKey());
      fluent.withContentRef(instance.getContentRef());
      fluent.withContentType(instance.getContentType());
      fluent.withInterceptors(instance.getInterceptors());
      fluent.withLanguage(instance.getLanguage());
      fluent.withLoader(instance.getLoader());
      fluent.withName(instance.getName());
      fluent.withPath(instance.getPath());
      fluent.withPropertyNames(instance.getPropertyNames());
      fluent.withRawContent(instance.getRawContent());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SourceSpecBuilder(SourceSpec instance) {
    this(instance,false);
  }
  public SourceSpecBuilder(SourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCompression(instance.getCompression());
      this.withContent(instance.getContent());
      this.withContentKey(instance.getContentKey());
      this.withContentRef(instance.getContentRef());
      this.withContentType(instance.getContentType());
      this.withInterceptors(instance.getInterceptors());
      this.withLanguage(instance.getLanguage());
      this.withLoader(instance.getLoader());
      this.withName(instance.getName());
      this.withPath(instance.getPath());
      this.withPropertyNames(instance.getPropertyNames());
      this.withRawContent(instance.getRawContent());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  SourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SourceSpec build() {
    SourceSpec buildable = new SourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getContentType(),fluent.getInterceptors(),fluent.getLanguage(),fluent.getLoader(),fluent.getName(),fluent.getPath(),fluent.getPropertyNames(),fluent.getRawContent(),fluent.getType());
    return buildable;
  }
  
}