package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerBuilder extends ServerFluentImpl<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder>{
  public ServerBuilder() {
    this(false);
  }
  public ServerBuilder(Boolean validationEnabled) {
    this(new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance) {
    this(fluent, instance, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withId(instance.getId());
      fluent.withPassword(instance.getPassword());
      fluent.withUsername(instance.getUsername());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerBuilder(Server instance) {
    this(instance,false);
  }
  public ServerBuilder(Server instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withId(instance.getId());
      this.withPassword(instance.getPassword());
      this.withUsername(instance.getUsername());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerFluent<?> fluent;
  Boolean validationEnabled;
  public Server build() {
    Server buildable = new Server(fluent.getConfiguration(),fluent.getId(),fluent.getPassword(),fluent.getUsername());
    return buildable;
  }
  
}