package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuntimeSpecFluentImpl<A extends RuntimeSpecFluent<A>> extends BaseFluent<A> implements RuntimeSpecFluent<A>{
  public RuntimeSpecFluentImpl() {
  }
  public RuntimeSpecFluentImpl(RuntimeSpec instance) {
    if (instance != null) {
      this.withApplicationClass(instance.getApplicationClass());
      this.withCapabilities(instance.getCapabilities());
      this.withDependencies(instance.getDependencies());
      this.withMetadata(instance.getMetadata());
      this.withProvider(instance.getProvider());
      this.withVersion(instance.getVersion());
    }
  }
  private String applicationClass;
  private Map<String,Capability> capabilities;
  private ArrayList<MavenArtifactBuilder> dependencies = new ArrayList<MavenArtifactBuilder>();
  private Map<String,String> metadata;
  private String provider;
  private String version;
  public String getApplicationClass() {
    return this.applicationClass;
  }
  public A withApplicationClass(String applicationClass) {
    this.applicationClass=applicationClass; return (A) this;
  }
  public Boolean hasApplicationClass() {
    return this.applicationClass != null;
  }
  public A addToCapabilities(String key,Capability value) {
    if(this.capabilities == null && key != null && value != null) { this.capabilities = new LinkedHashMap(); }
    if(key != null && value != null) {this.capabilities.put(key, value);} return (A)this;
  }
  public A addToCapabilities(Map<String,Capability> map) {
    if(this.capabilities == null && map != null) { this.capabilities = new LinkedHashMap(); }
    if(map != null) { this.capabilities.putAll(map);} return (A)this;
  }
  public A removeFromCapabilities(String key) {
    if(this.capabilities == null) { return (A) this; }
    if(key != null && this.capabilities != null) {this.capabilities.remove(key);} return (A)this;
  }
  public A removeFromCapabilities(Map<String,Capability> map) {
    if(this.capabilities == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capabilities != null){this.capabilities.remove(key);}}} return (A)this;
  }
  public Map<String,Capability> getCapabilities() {
    return this.capabilities;
  }
  public <K,V>A withCapabilities(Map<String,Capability> capabilities) {
    if (capabilities == null) { this.capabilities =  null;} else {this.capabilities = new LinkedHashMap(capabilities);} return (A) this;
  }
  public Boolean hasCapabilities() {
    return this.capabilities != null;
  }
  public A addToDependencies(int index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  public A setToDependencies(int index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<MavenArtifact> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public List<MavenArtifact> buildDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public MavenArtifact buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  public MavenArtifact buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public MavenArtifact buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<MavenArtifact> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").clear();}
    if (dependencies != null) {this.dependencies = new ArrayList(); for (MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.MavenArtifact... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(String artifactId,String groupId,String version) {
    return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> addNewDependency() {
    return new RuntimeSpecFluentImpl.DependenciesNestedImpl();
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
    return new RuntimeSpecFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item) {
    return new RuntimeSpecFluentImpl.DependenciesNestedImpl(index, item);
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public RuntimeSpecFluentImpl.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A addToMetadata(String key,String value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  public A addToMetadata(Map<String,String> map) {
    if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  public A removeFromMetadata(String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  public A removeFromMetadata(Map<String,String> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMetadata() {
    return this.metadata;
  }
  public <K,V>A withMetadata(Map<String,String> metadata) {
    if (metadata == null) { this.metadata =  null;} else {this.metadata = new LinkedHashMap(metadata);} return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public String getProvider() {
    return this.provider;
  }
  public A withProvider(String provider) {
    this.provider=provider; return (A) this;
  }
  public Boolean hasProvider() {
    return this.provider != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuntimeSpecFluentImpl that = (RuntimeSpecFluentImpl) o;
    if (!java.util.Objects.equals(applicationClass, that.applicationClass)) return false;

    if (!java.util.Objects.equals(capabilities, that.capabilities)) return false;

    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(provider, that.provider)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(applicationClass,  capabilities,  dependencies,  metadata,  provider,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationClass != null) { sb.append("applicationClass:"); sb.append(applicationClass + ","); }
    if (capabilities != null && !capabilities.isEmpty()) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (dependencies != null) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<RuntimeSpecFluentImpl.DependenciesNested<N>> implements RuntimeSpecFluentImpl.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(int index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    int index;
    public N and() {
      return (N) RuntimeSpecFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  
}