package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceSpecBuilder extends ResourceSpecFluentImpl<ResourceSpecBuilder> implements VisitableBuilder<ResourceSpec,ResourceSpecBuilder>{
  public ResourceSpecBuilder() {
    this(false);
  }
  public ResourceSpecBuilder(Boolean validationEnabled) {
    this(new ResourceSpec(), validationEnabled);
  }
  public ResourceSpecBuilder(ResourceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceSpec(), validationEnabled);
  }
  public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,ResourceSpec instance) {
    this(fluent, instance, false);
  }
  public ResourceSpecBuilder(ResourceSpecFluent<?> fluent,ResourceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCompression(instance.getCompression());
      fluent.withContent(instance.getContent());
      fluent.withContentKey(instance.getContentKey());
      fluent.withContentRef(instance.getContentRef());
      fluent.withContentType(instance.getContentType());
      fluent.withMountPath(instance.getMountPath());
      fluent.withName(instance.getName());
      fluent.withPath(instance.getPath());
      fluent.withRawContent(instance.getRawContent());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceSpecBuilder(ResourceSpec instance) {
    this(instance,false);
  }
  public ResourceSpecBuilder(ResourceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCompression(instance.getCompression());
      this.withContent(instance.getContent());
      this.withContentKey(instance.getContentKey());
      this.withContentRef(instance.getContentRef());
      this.withContentType(instance.getContentType());
      this.withMountPath(instance.getMountPath());
      this.withName(instance.getName());
      this.withPath(instance.getPath());
      this.withRawContent(instance.getRawContent());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceSpec build() {
    ResourceSpec buildable = new ResourceSpec(fluent.getCompression(),fluent.getContent(),fluent.getContentKey(),fluent.getContentRef(),fluent.getContentType(),fluent.getMountPath(),fluent.getName(),fluent.getPath(),fluent.getRawContent(),fluent.getType());
    return buildable;
  }
  
}