package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RepositoryPolicyBuilder extends RepositoryPolicyFluentImpl<RepositoryPolicyBuilder> implements VisitableBuilder<RepositoryPolicy,RepositoryPolicyBuilder>{
  public RepositoryPolicyBuilder() {
    this(false);
  }
  public RepositoryPolicyBuilder(Boolean validationEnabled) {
    this(new RepositoryPolicy(), validationEnabled);
  }
  public RepositoryPolicyBuilder(RepositoryPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public RepositoryPolicyBuilder(RepositoryPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RepositoryPolicy(), validationEnabled);
  }
  public RepositoryPolicyBuilder(RepositoryPolicyFluent<?> fluent,RepositoryPolicy instance) {
    this(fluent, instance, false);
  }
  public RepositoryPolicyBuilder(RepositoryPolicyFluent<?> fluent,RepositoryPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChecksumPolicy(instance.getChecksumPolicy());
      fluent.withEnabled(instance.getEnabled());
      fluent.withUpdatePolicy(instance.getUpdatePolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RepositoryPolicyBuilder(RepositoryPolicy instance) {
    this(instance,false);
  }
  public RepositoryPolicyBuilder(RepositoryPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChecksumPolicy(instance.getChecksumPolicy());
      this.withEnabled(instance.getEnabled());
      this.withUpdatePolicy(instance.getUpdatePolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  RepositoryPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public RepositoryPolicy build() {
    RepositoryPolicy buildable = new RepositoryPolicy(fluent.getChecksumPolicy(),fluent.getEnabled(),fluent.getUpdatePolicy());
    return buildable;
  }
  
}