package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSpecTemplateBuilder extends PodSpecTemplateFluentImpl<PodSpecTemplateBuilder> implements VisitableBuilder<PodSpecTemplate,PodSpecTemplateBuilder>{
  public PodSpecTemplateBuilder() {
    this(false);
  }
  public PodSpecTemplateBuilder(Boolean validationEnabled) {
    this(new PodSpecTemplate(), validationEnabled);
  }
  public PodSpecTemplateBuilder(PodSpecTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSpecTemplateBuilder(PodSpecTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSpecTemplate(), validationEnabled);
  }
  public PodSpecTemplateBuilder(PodSpecTemplateFluent<?> fluent,PodSpecTemplate instance) {
    this(fluent, instance, false);
  }
  public PodSpecTemplateBuilder(PodSpecTemplateFluent<?> fluent,PodSpecTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSpecTemplateBuilder(PodSpecTemplate instance) {
    this(instance,false);
  }
  public PodSpecTemplateBuilder(PodSpecTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSpecTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public PodSpecTemplate build() {
    PodSpecTemplate buildable = new PodSpecTemplate(fluent.getSpec());
    return buildable;
  }
  
}