package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MavenSpecFluentImpl<A extends MavenSpecFluent<A>> extends BaseFluent<A> implements MavenSpecFluent<A>{
  public MavenSpecFluentImpl() {
  }
  public MavenSpecFluentImpl(MavenSpec instance) {
    if (instance != null) {
      this.withCaSecret(instance.getCaSecret());
      this.withCaSecrets(instance.getCaSecrets());
      this.withCliOptions(instance.getCliOptions());
      this.withExtension(instance.getExtension());
      this.withLocalRepository(instance.getLocalRepository());
      this.withProperties(instance.getProperties());
      this.withSettings(instance.getSettings());
    }
  }
  private SecretKeySelector caSecret;
  private List<SecretKeySelector> caSecrets = new ArrayList<SecretKeySelector>();
  private List<String> cliOptions = new ArrayList<String>();
  private ArrayList<MavenArtifactBuilder> extension = new ArrayList<MavenArtifactBuilder>();
  private String localRepository;
  private Map<String,String> properties;
  private ValueSourceBuilder settings;
  public SecretKeySelector getCaSecret() {
    return this.caSecret;
  }
  public A withCaSecret(SecretKeySelector caSecret) {
    this.caSecret=caSecret; return (A) this;
  }
  public Boolean hasCaSecret() {
    return this.caSecret != null;
  }
  public A withNewCaSecret(String key,String name,Boolean optional) {
    return (A)withCaSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToCaSecrets(int index,SecretKeySelector item) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    this.caSecrets.add(index, item);
    return (A)this;
  }
  public A setToCaSecrets(int index,SecretKeySelector item) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    this.caSecrets.set(index, item); return (A)this;
  }
  public A addToCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    for (SecretKeySelector item : items) {this.caSecrets.add(item);} return (A)this;
  }
  public A addAllToCaSecrets(Collection<SecretKeySelector> items) {
    if (this.caSecrets == null) {this.caSecrets = new ArrayList<SecretKeySelector>();}
    for (SecretKeySelector item : items) {this.caSecrets.add(item);} return (A)this;
  }
  public A removeFromCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... items) {
    for (SecretKeySelector item : items) {if (this.caSecrets!= null){ this.caSecrets.remove(item);}} return (A)this;
  }
  public A removeAllFromCaSecrets(Collection<SecretKeySelector> items) {
    for (SecretKeySelector item : items) {if (this.caSecrets!= null){ this.caSecrets.remove(item);}} return (A)this;
  }
  public List<SecretKeySelector> getCaSecrets() {
    return this.caSecrets;
  }
  public SecretKeySelector getCaSecret(int index) {
    return this.caSecrets.get(index);
  }
  public SecretKeySelector getFirstCaSecret() {
    return this.caSecrets.get(0);
  }
  public SecretKeySelector getLastCaSecret() {
    return this.caSecrets.get(caSecrets.size() - 1);
  }
  public SecretKeySelector getMatchingCaSecret(Predicate<SecretKeySelector> predicate) {
    for (SecretKeySelector item: caSecrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCaSecret(Predicate<SecretKeySelector> predicate) {
    for (SecretKeySelector item: caSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCaSecrets(List<SecretKeySelector> caSecrets) {
    if (caSecrets != null) {this.caSecrets = new ArrayList(); for (SecretKeySelector item : caSecrets){this.addToCaSecrets(item);}} else { this.caSecrets = null;} return (A) this;
  }
  public A withCaSecrets(io.fabric8.kubernetes.api.model.SecretKeySelector... caSecrets) {
    if (this.caSecrets != null) {this.caSecrets.clear(); _visitables.remove("caSecrets"); }
    if (caSecrets != null) {for (SecretKeySelector item :caSecrets){ this.addToCaSecrets(item);}} return (A) this;
  }
  public Boolean hasCaSecrets() {
    return caSecrets != null && !caSecrets.isEmpty();
  }
  public A addNewCaSecret(String key,String name,Boolean optional) {
    return (A)addToCaSecrets(new SecretKeySelector(key, name, optional));
  }
  public A addToCliOptions(int index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.add(index, item);
    return (A)this;
  }
  public A setToCliOptions(int index,String item) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    this.cliOptions.set(index, item); return (A)this;
  }
  public A addToCliOptions(java.lang.String... items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A addAllToCliOptions(Collection<String> items) {
    if (this.cliOptions == null) {this.cliOptions = new ArrayList<String>();}
    for (String item : items) {this.cliOptions.add(item);} return (A)this;
  }
  public A removeFromCliOptions(java.lang.String... items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromCliOptions(Collection<String> items) {
    for (String item : items) {if (this.cliOptions!= null){ this.cliOptions.remove(item);}} return (A)this;
  }
  public List<String> getCliOptions() {
    return this.cliOptions;
  }
  public String getCliOption(int index) {
    return this.cliOptions.get(index);
  }
  public String getFirstCliOption() {
    return this.cliOptions.get(0);
  }
  public String getLastCliOption() {
    return this.cliOptions.get(cliOptions.size() - 1);
  }
  public String getMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCliOption(Predicate<String> predicate) {
    for (String item: cliOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCliOptions(List<String> cliOptions) {
    if (cliOptions != null) {this.cliOptions = new ArrayList(); for (String item : cliOptions){this.addToCliOptions(item);}} else { this.cliOptions = null;} return (A) this;
  }
  public A withCliOptions(java.lang.String... cliOptions) {
    if (this.cliOptions != null) {this.cliOptions.clear(); _visitables.remove("cliOptions"); }
    if (cliOptions != null) {for (String item :cliOptions){ this.addToCliOptions(item);}} return (A) this;
  }
  public Boolean hasCliOptions() {
    return cliOptions != null && !cliOptions.isEmpty();
  }
  public A addToExtension(int index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= extension.size()) { _visitables.get("extension").add(builder); extension.add(builder); } else { _visitables.get("extension").add(index, builder); extension.add(index, builder);}
    return (A)this;
  }
  public A setToExtension(int index,MavenArtifact item) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= extension.size()) { _visitables.get("extension").add(builder); extension.add(builder); } else { _visitables.get("extension").set(index, builder); extension.set(index, builder);}
    return (A)this;
  }
  public A addToExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A addAllToExtension(Collection<MavenArtifact> items) {
    if (this.extension == null) {this.extension = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").add(builder);this.extension.add(builder);} return (A)this;
  }
  public A removeFromExtension(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeAllFromExtension(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("extension").remove(builder);if (this.extension != null) {this.extension.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate) {
    if (extension == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = extension.iterator();
    final List visitables = _visitables.get("extension");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExtension instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getExtension() {
    return extension != null ? build(extension) : null;
  }
  public List<MavenArtifact> buildExtension() {
    return extension != null ? build(extension) : null;
  }
  public MavenArtifact buildExtension(int index) {
    return this.extension.get(index).build();
  }
  public MavenArtifact buildFirstExtension() {
    return this.extension.get(0).build();
  }
  public MavenArtifact buildLastExtension() {
    return this.extension.get(extension.size() - 1).build();
  }
  public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: extension) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExtension(List<MavenArtifact> extension) {
    if (this.extension != null) { _visitables.get("extension").clear();}
    if (extension != null) {this.extension = new ArrayList(); for (MavenArtifact item : extension){this.addToExtension(item);}} else { this.extension = null;} return (A) this;
  }
  public A withExtension(io.fabric8.camelk.v1.MavenArtifact... extension) {
    if (this.extension != null) {this.extension.clear(); _visitables.remove("extension"); }
    if (extension != null) {for (MavenArtifact item :extension){ this.addToExtension(item);}} return (A) this;
  }
  public Boolean hasExtension() {
    return extension != null && !extension.isEmpty();
  }
  public A addNewExtension(String artifactId,String groupId,String version) {
    return (A)addToExtension(new MavenArtifact(artifactId, groupId, version));
  }
  public MavenSpecFluentImpl.ExtensionNested<A> addNewExtension() {
    return new MavenSpecFluentImpl.ExtensionNestedImpl();
  }
  public MavenSpecFluentImpl.ExtensionNested<A> addNewExtensionLike(MavenArtifact item) {
    return new MavenSpecFluentImpl.ExtensionNestedImpl(-1, item);
  }
  public MavenSpecFluentImpl.ExtensionNested<A> setNewExtensionLike(int index,MavenArtifact item) {
    return new MavenSpecFluentImpl.ExtensionNestedImpl(index, item);
  }
  public MavenSpecFluentImpl.ExtensionNested<A> editExtension(int index) {
    if (extension.size() <= index) throw new RuntimeException("Can't edit extension. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenSpecFluentImpl.ExtensionNested<A> editFirstExtension() {
    if (extension.size() == 0) throw new RuntimeException("Can't edit first extension. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  public MavenSpecFluentImpl.ExtensionNested<A> editLastExtension() {
    int index = extension.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extension. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public MavenSpecFluentImpl.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extension.size();i++) { 
    if (predicate.test(extension.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extension. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  public String getLocalRepository() {
    return this.localRepository;
  }
  public A withLocalRepository(String localRepository) {
    this.localRepository=localRepository; return (A) this;
  }
  public Boolean hasLocalRepository() {
    return this.localRepository != null;
  }
  public A addToProperties(String key,String value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  public A addToProperties(Map<String,String> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  public A removeFromProperties(Map<String,String> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  public Map<String,String> getProperties() {
    return this.properties;
  }
  public <K,V>A withProperties(Map<String,String> properties) {
    if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap(properties);} return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValueSource getSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public ValueSource buildSettings() {
    return this.settings!=null ?this.settings.build():null;
  }
  public A withSettings(ValueSource settings) {
    _visitables.get("settings").remove(this.settings);
    if (settings!=null){ this.settings= new ValueSourceBuilder(settings); _visitables.get("settings").add(this.settings);} else { this.settings = null; _visitables.get("settings").remove(this.settings); } return (A) this;
  }
  public Boolean hasSettings() {
    return this.settings != null;
  }
  public MavenSpecFluentImpl.SettingsNested<A> withNewSettings() {
    return new MavenSpecFluentImpl.SettingsNestedImpl();
  }
  public MavenSpecFluentImpl.SettingsNested<A> withNewSettingsLike(ValueSource item) {
    return new MavenSpecFluentImpl.SettingsNestedImpl(item);
  }
  public MavenSpecFluentImpl.SettingsNested<A> editSettings() {
    return withNewSettingsLike(getSettings());
  }
  public MavenSpecFluentImpl.SettingsNested<A> editOrNewSettings() {
    return withNewSettingsLike(getSettings() != null ? getSettings(): new ValueSourceBuilder().build());
  }
  public MavenSpecFluentImpl.SettingsNested<A> editOrNewSettingsLike(ValueSource item) {
    return withNewSettingsLike(getSettings() != null ? getSettings(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MavenSpecFluentImpl that = (MavenSpecFluentImpl) o;
    if (!java.util.Objects.equals(caSecret, that.caSecret)) return false;

    if (!java.util.Objects.equals(caSecrets, that.caSecrets)) return false;

    if (!java.util.Objects.equals(cliOptions, that.cliOptions)) return false;

    if (!java.util.Objects.equals(extension, that.extension)) return false;

    if (!java.util.Objects.equals(localRepository, that.localRepository)) return false;

    if (!java.util.Objects.equals(properties, that.properties)) return false;

    if (!java.util.Objects.equals(settings, that.settings)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caSecret,  caSecrets,  cliOptions,  extension,  localRepository,  properties,  settings,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caSecret != null) { sb.append("caSecret:"); sb.append(caSecret + ","); }
    if (caSecrets != null && !caSecrets.isEmpty()) { sb.append("caSecrets:"); sb.append(caSecrets + ","); }
    if (cliOptions != null && !cliOptions.isEmpty()) { sb.append("cliOptions:"); sb.append(cliOptions + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (localRepository != null) { sb.append("localRepository:"); sb.append(localRepository + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (settings != null) { sb.append("settings:"); sb.append(settings); }
    sb.append("}");
    return sb.toString();
  }
  class ExtensionNestedImpl<N> extends MavenArtifactFluentImpl<MavenSpecFluentImpl.ExtensionNested<N>> implements MavenSpecFluentImpl.ExtensionNested<N>,Nested<N>{
    ExtensionNestedImpl(int index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    ExtensionNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    int index;
    public N and() {
      return (N) MavenSpecFluentImpl.this.setToExtension(index,builder.build());
    }
    public N endExtension() {
      return and();
    }
    
  }
  class SettingsNestedImpl<N> extends ValueSourceFluentImpl<MavenSpecFluentImpl.SettingsNested<N>> implements MavenSpecFluentImpl.SettingsNested<N>,Nested<N>{
    SettingsNestedImpl(ValueSource item) {
      this.builder = new ValueSourceBuilder(this, item);
    }
    SettingsNestedImpl() {
      this.builder = new ValueSourceBuilder(this);
    }
    ValueSourceBuilder builder;
    public N and() {
      return (N) MavenSpecFluentImpl.this.withSettings(builder.build());
    }
    public N endSettings() {
      return and();
    }
    
  }
  
}