package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KanikoTaskFluentImpl<A extends KanikoTaskFluent<A>> extends BaseFluent<A> implements KanikoTaskFluent<A>{
  public KanikoTaskFluentImpl() {
  }
  public KanikoTaskFluentImpl(KanikoTask instance) {
    if (instance != null) {
      this.withBaseImage(instance.getBaseImage());
      this.withCache(instance.getCache());
      this.withContextDir(instance.getContextDir());
      this.withImage(instance.getImage());
      this.withName(instance.getName());
      this.withRegistry(instance.getRegistry());
      this.withVerbose(instance.getVerbose());
    }
  }
  private String baseImage;
  private KanikoTaskCacheBuilder cache;
  private String contextDir;
  private String image;
  private String name;
  private RegistrySpecBuilder registry;
  private Boolean verbose;
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCache instead.
   * @return The buildable object.
   */
  @Deprecated
  public KanikoTaskCache getCache() {
    return this.cache!=null ?this.cache.build():null;
  }
  public KanikoTaskCache buildCache() {
    return this.cache!=null ?this.cache.build():null;
  }
  public A withCache(KanikoTaskCache cache) {
    _visitables.get("cache").remove(this.cache);
    if (cache!=null){ this.cache= new KanikoTaskCacheBuilder(cache); _visitables.get("cache").add(this.cache);} else { this.cache = null; _visitables.get("cache").remove(this.cache); } return (A) this;
  }
  public Boolean hasCache() {
    return this.cache != null;
  }
  public A withNewCache(Boolean enabled,String persistentVolumeClaim) {
    return (A)withCache(new KanikoTaskCache(enabled, persistentVolumeClaim));
  }
  public KanikoTaskFluentImpl.CacheNested<A> withNewCache() {
    return new KanikoTaskFluentImpl.CacheNestedImpl();
  }
  public KanikoTaskFluentImpl.CacheNested<A> withNewCacheLike(KanikoTaskCache item) {
    return new KanikoTaskFluentImpl.CacheNestedImpl(item);
  }
  public KanikoTaskFluentImpl.CacheNested<A> editCache() {
    return withNewCacheLike(getCache());
  }
  public KanikoTaskFluentImpl.CacheNested<A> editOrNewCache() {
    return withNewCacheLike(getCache() != null ? getCache(): new KanikoTaskCacheBuilder().build());
  }
  public KanikoTaskFluentImpl.CacheNested<A> editOrNewCacheLike(KanikoTaskCache item) {
    return withNewCacheLike(getCache() != null ? getCache(): item);
  }
  public String getContextDir() {
    return this.contextDir;
  }
  public A withContextDir(String contextDir) {
    this.contextDir=contextDir; return (A) this;
  }
  public Boolean hasContextDir() {
    return this.contextDir != null;
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRegistry instead.
   * @return The buildable object.
   */
  @Deprecated
  public RegistrySpec getRegistry() {
    return this.registry!=null ?this.registry.build():null;
  }
  public RegistrySpec buildRegistry() {
    return this.registry!=null ?this.registry.build():null;
  }
  public A withRegistry(RegistrySpec registry) {
    _visitables.get("registry").remove(this.registry);
    if (registry!=null){ this.registry= new RegistrySpecBuilder(registry); _visitables.get("registry").add(this.registry);} else { this.registry = null; _visitables.get("registry").remove(this.registry); } return (A) this;
  }
  public Boolean hasRegistry() {
    return this.registry != null;
  }
  public A withNewRegistry(String address,String ca,Boolean insecure,String organization,String secret) {
    return (A)withRegistry(new RegistrySpec(address, ca, insecure, organization, secret));
  }
  public KanikoTaskFluentImpl.RegistryNested<A> withNewRegistry() {
    return new KanikoTaskFluentImpl.RegistryNestedImpl();
  }
  public KanikoTaskFluentImpl.RegistryNested<A> withNewRegistryLike(RegistrySpec item) {
    return new KanikoTaskFluentImpl.RegistryNestedImpl(item);
  }
  public KanikoTaskFluentImpl.RegistryNested<A> editRegistry() {
    return withNewRegistryLike(getRegistry());
  }
  public KanikoTaskFluentImpl.RegistryNested<A> editOrNewRegistry() {
    return withNewRegistryLike(getRegistry() != null ? getRegistry(): new RegistrySpecBuilder().build());
  }
  public KanikoTaskFluentImpl.RegistryNested<A> editOrNewRegistryLike(RegistrySpec item) {
    return withNewRegistryLike(getRegistry() != null ? getRegistry(): item);
  }
  public Boolean getVerbose() {
    return this.verbose;
  }
  public A withVerbose(Boolean verbose) {
    this.verbose=verbose; return (A) this;
  }
  public Boolean hasVerbose() {
    return this.verbose != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KanikoTaskFluentImpl that = (KanikoTaskFluentImpl) o;
    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;

    if (!java.util.Objects.equals(cache, that.cache)) return false;

    if (!java.util.Objects.equals(contextDir, that.contextDir)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(registry, that.registry)) return false;

    if (!java.util.Objects.equals(verbose, that.verbose)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  cache,  contextDir,  image,  name,  registry,  verbose,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (cache != null) { sb.append("cache:"); sb.append(cache + ","); }
    if (contextDir != null) { sb.append("contextDir:"); sb.append(contextDir + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (registry != null) { sb.append("registry:"); sb.append(registry + ","); }
    if (verbose != null) { sb.append("verbose:"); sb.append(verbose); }
    sb.append("}");
    return sb.toString();
  }
  public A withVerbose() {
    return withVerbose(true);
  }
  class CacheNestedImpl<N> extends KanikoTaskCacheFluentImpl<KanikoTaskFluentImpl.CacheNested<N>> implements KanikoTaskFluentImpl.CacheNested<N>,Nested<N>{
    CacheNestedImpl(KanikoTaskCache item) {
      this.builder = new KanikoTaskCacheBuilder(this, item);
    }
    CacheNestedImpl() {
      this.builder = new KanikoTaskCacheBuilder(this);
    }
    KanikoTaskCacheBuilder builder;
    public N and() {
      return (N) KanikoTaskFluentImpl.this.withCache(builder.build());
    }
    public N endCache() {
      return and();
    }
    
  }
  class RegistryNestedImpl<N> extends RegistrySpecFluentImpl<KanikoTaskFluentImpl.RegistryNested<N>> implements KanikoTaskFluentImpl.RegistryNested<N>,Nested<N>{
    RegistryNestedImpl(RegistrySpec item) {
      this.builder = new RegistrySpecBuilder(this, item);
    }
    RegistryNestedImpl() {
      this.builder = new RegistrySpecBuilder(this);
    }
    RegistrySpecBuilder builder;
    public N and() {
      return (N) KanikoTaskFluentImpl.this.withRegistry(builder.build());
    }
    public N endRegistry() {
      return and();
    }
    
  }
  
}