package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KanikoTaskCacheBuilder extends KanikoTaskCacheFluentImpl<KanikoTaskCacheBuilder> implements VisitableBuilder<KanikoTaskCache,KanikoTaskCacheBuilder>{
  public KanikoTaskCacheBuilder() {
    this(false);
  }
  public KanikoTaskCacheBuilder(Boolean validationEnabled) {
    this(new KanikoTaskCache(), validationEnabled);
  }
  public KanikoTaskCacheBuilder(KanikoTaskCacheFluent<?> fluent) {
    this(fluent, false);
  }
  public KanikoTaskCacheBuilder(KanikoTaskCacheFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KanikoTaskCache(), validationEnabled);
  }
  public KanikoTaskCacheBuilder(KanikoTaskCacheFluent<?> fluent,KanikoTaskCache instance) {
    this(fluent, instance, false);
  }
  public KanikoTaskCacheBuilder(KanikoTaskCacheFluent<?> fluent,KanikoTaskCache instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEnabled(instance.getEnabled());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KanikoTaskCacheBuilder(KanikoTaskCache instance) {
    this(instance,false);
  }
  public KanikoTaskCacheBuilder(KanikoTaskCache instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEnabled(instance.getEnabled());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
    }
    this.validationEnabled = validationEnabled; 
  }
  KanikoTaskCacheFluent<?> fluent;
  Boolean validationEnabled;
  public KanikoTaskCache build() {
    KanikoTaskCache buildable = new KanikoTaskCache(fluent.getEnabled(),fluent.getPersistentVolumeClaim());
    return buildable;
  }
  
}