package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KanikoTaskBuilder extends KanikoTaskFluentImpl<KanikoTaskBuilder> implements VisitableBuilder<KanikoTask,KanikoTaskBuilder>{
  public KanikoTaskBuilder() {
    this(false);
  }
  public KanikoTaskBuilder(Boolean validationEnabled) {
    this(new KanikoTask(), validationEnabled);
  }
  public KanikoTaskBuilder(KanikoTaskFluent<?> fluent) {
    this(fluent, false);
  }
  public KanikoTaskBuilder(KanikoTaskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KanikoTask(), validationEnabled);
  }
  public KanikoTaskBuilder(KanikoTaskFluent<?> fluent,KanikoTask instance) {
    this(fluent, instance, false);
  }
  public KanikoTaskBuilder(KanikoTaskFluent<?> fluent,KanikoTask instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBaseImage(instance.getBaseImage());
      fluent.withCache(instance.getCache());
      fluent.withContextDir(instance.getContextDir());
      fluent.withImage(instance.getImage());
      fluent.withName(instance.getName());
      fluent.withRegistry(instance.getRegistry());
      fluent.withVerbose(instance.getVerbose());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KanikoTaskBuilder(KanikoTask instance) {
    this(instance,false);
  }
  public KanikoTaskBuilder(KanikoTask instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBaseImage(instance.getBaseImage());
      this.withCache(instance.getCache());
      this.withContextDir(instance.getContextDir());
      this.withImage(instance.getImage());
      this.withName(instance.getName());
      this.withRegistry(instance.getRegistry());
      this.withVerbose(instance.getVerbose());
    }
    this.validationEnabled = validationEnabled; 
  }
  KanikoTaskFluent<?> fluent;
  Boolean validationEnabled;
  public KanikoTask build() {
    KanikoTask buildable = new KanikoTask(fluent.getBaseImage(),fluent.getCache(),fluent.getContextDir(),fluent.getImage(),fluent.getName(),fluent.getRegistry(),fluent.getVerbose());
    return buildable;
  }
  
}