package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationSpecFluentImpl<A extends IntegrationSpecFluent<A>> extends BaseFluent<A> implements IntegrationSpecFluent<A>{
  public IntegrationSpecFluentImpl() {
  }
  public IntegrationSpecFluentImpl(IntegrationSpec instance) {
    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withDependencies(instance.getDependencies());
      this.withFlows(instance.getFlows());
      this.withIntegrationKit(instance.getIntegrationKit());
      this.withProfile(instance.getProfile());
      this.withReplicas(instance.getReplicas());
      this.withRepositories(instance.getRepositories());
      this.withResources(instance.getResources());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withSources(instance.getSources());
      this.withTemplate(instance.getTemplate());
      this.withTraits(instance.getTraits());
    }
  }
  private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList<ConfigurationSpecBuilder>();
  private List<String> dependencies = new ArrayList<String>();
  private List<JsonNode> flows = new ArrayList<JsonNode>();
  private ObjectReferenceBuilder integrationKit;
  private String profile;
  private Integer replicas;
  private List<String> repositories = new ArrayList<String>();
  private ArrayList<ResourceSpecBuilder> resources = new ArrayList<ResourceSpecBuilder>();
  private String serviceAccountName;
  private ArrayList<SourceSpecBuilder> sources = new ArrayList<SourceSpecBuilder>();
  private PodSpecTemplateBuilder template;
  private Map<String,TraitSpec> traits;
  public A addToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").add(index, builder); configuration.add(index, builder);}
    return (A)this;
  }
  public A setToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").set(index, builder); configuration.set(index, builder);}
    return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public List<ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public ConfigurationSpec buildConfiguration(int index) {
    return this.configuration.get(index).build();
  }
  public ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(List<ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").clear();}
    if (configuration != null) {this.configuration = new ArrayList(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear(); _visitables.remove("configuration"); }
    if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationSpecFluentImpl.ConfigurationNestedImpl();
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
    return new IntegrationSpecFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
    return new IntegrationSpecFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> editConfiguration(int index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationSpecFluentImpl.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(int index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(int index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(int index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addToFlows(int index,JsonNode item) {
    if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
    this.flows.add(index, item);
    return (A)this;
  }
  public A setToFlows(int index,JsonNode item) {
    if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
    this.flows.set(index, item); return (A)this;
  }
  public A addToFlows(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.flows.add(item);} return (A)this;
  }
  public A addAllToFlows(Collection<JsonNode> items) {
    if (this.flows == null) {this.flows = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.flows.add(item);} return (A)this;
  }
  public A removeFromFlows(com.fasterxml.jackson.databind.JsonNode... items) {
    for (JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
  }
  public A removeAllFromFlows(Collection<JsonNode> items) {
    for (JsonNode item : items) {if (this.flows!= null){ this.flows.remove(item);}} return (A)this;
  }
  public List<JsonNode> getFlows() {
    return this.flows;
  }
  public JsonNode getFlow(int index) {
    return this.flows.get(index);
  }
  public JsonNode getFirstFlow() {
    return this.flows.get(0);
  }
  public JsonNode getLastFlow() {
    return this.flows.get(flows.size() - 1);
  }
  public JsonNode getMatchingFlow(Predicate<JsonNode> predicate) {
    for (JsonNode item: flows) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingFlow(Predicate<JsonNode> predicate) {
    for (JsonNode item: flows) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFlows(List<JsonNode> flows) {
    if (flows != null) {this.flows = new ArrayList(); for (JsonNode item : flows){this.addToFlows(item);}} else { this.flows = null;} return (A) this;
  }
  public A withFlows(com.fasterxml.jackson.databind.JsonNode... flows) {
    if (this.flows != null) {this.flows.clear(); _visitables.remove("flows"); }
    if (flows != null) {for (JsonNode item :flows){ this.addToFlows(item);}} return (A) this;
  }
  public Boolean hasFlows() {
    return flows != null && !flows.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildIntegrationKit instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public ObjectReference buildIntegrationKit() {
    return this.integrationKit!=null ?this.integrationKit.build():null;
  }
  public A withIntegrationKit(ObjectReference integrationKit) {
    _visitables.get("integrationKit").remove(this.integrationKit);
    if (integrationKit!=null){ this.integrationKit= new ObjectReferenceBuilder(integrationKit); _visitables.get("integrationKit").add(this.integrationKit);} else { this.integrationKit = null; _visitables.get("integrationKit").remove(this.integrationKit); } return (A) this;
  }
  public Boolean hasIntegrationKit() {
    return this.integrationKit != null;
  }
  public IntegrationSpecFluentImpl.IntegrationKitNested<A> withNewIntegrationKit() {
    return new IntegrationSpecFluentImpl.IntegrationKitNestedImpl();
  }
  public IntegrationSpecFluentImpl.IntegrationKitNested<A> withNewIntegrationKitLike(ObjectReference item) {
    return new IntegrationSpecFluentImpl.IntegrationKitNestedImpl(item);
  }
  public IntegrationSpecFluentImpl.IntegrationKitNested<A> editIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit());
  }
  public IntegrationSpecFluentImpl.IntegrationKitNested<A> editOrNewIntegrationKit() {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): new ObjectReferenceBuilder().build());
  }
  public IntegrationSpecFluentImpl.IntegrationKitNested<A> editOrNewIntegrationKitLike(ObjectReference item) {
    return withNewIntegrationKitLike(getIntegrationKit() != null ? getIntegrationKit(): item);
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToRepositories(int index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.add(index, item);
    return (A)this;
  }
  public A setToRepositories(int index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.set(index, item); return (A)this;
  }
  public A addToRepositories(java.lang.String... items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A addAllToRepositories(Collection<String> items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A removeFromRepositories(java.lang.String... items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public A removeAllFromRepositories(Collection<String> items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public List<String> getRepositories() {
    return this.repositories;
  }
  public String getRepository(int index) {
    return this.repositories.get(index);
  }
  public String getFirstRepository() {
    return this.repositories.get(0);
  }
  public String getLastRepository() {
    return this.repositories.get(repositories.size() - 1);
  }
  public String getMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRepositories(List<String> repositories) {
    if (repositories != null) {this.repositories = new ArrayList(); for (String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
  }
  public A withRepositories(java.lang.String... repositories) {
    if (this.repositories != null) {this.repositories.clear(); _visitables.remove("repositories"); }
    if (repositories != null) {for (String item :repositories){ this.addToRepositories(item);}} return (A) this;
  }
  public Boolean hasRepositories() {
    return repositories != null && !repositories.isEmpty();
  }
  public A addToResources(int index,ResourceSpec item) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").add(index, builder); resources.add(index, builder);}
    return (A)this;
  }
  public A setToResources(int index,ResourceSpec item) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
    if (index < 0 || index >= resources.size()) { _visitables.get("resources").add(builder); resources.add(builder); } else { _visitables.get("resources").set(index, builder); resources.set(index, builder);}
    return (A)this;
  }
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A addAllToResources(Collection<ResourceSpec> items) {
    if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
  }
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeAllFromResources(Collection<ResourceSpec> items) {
    for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
    if (resources == null) return (A) this;
    final Iterator<ResourceSpecBuilder> each = resources.iterator();
    final List visitables = _visitables.get("resources");
    while (each.hasNext()) {
      ResourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getResources() {
    return resources != null ? build(resources) : null;
  }
  public List<ResourceSpec> buildResources() {
    return resources != null ? build(resources) : null;
  }
  public ResourceSpec buildResource(int index) {
    return this.resources.get(index).build();
  }
  public ResourceSpec buildFirstResource() {
    return this.resources.get(0).build();
  }
  public ResourceSpec buildLastResource() {
    return this.resources.get(resources.size() - 1).build();
  }
  public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<ResourceSpec> resources) {
    if (this.resources != null) { _visitables.get("resources").clear();}
    if (resources != null) {this.resources = new ArrayList(); for (ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> addNewResource() {
    return new IntegrationSpecFluentImpl.ResourcesNestedImpl();
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
    return new IntegrationSpecFluentImpl.ResourcesNestedImpl(-1, item);
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item) {
    return new IntegrationSpecFluentImpl.ResourcesNestedImpl(index, item);
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> editResource(int index) {
    if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
    return setNewResourceLike(index, buildResource(index));
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> editFirstResource() {
    if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
    return setNewResourceLike(0, buildResource(0));
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> editLastResource() {
    int index = resources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
    return setNewResourceLike(index, buildResource(index));
  }
  public IntegrationSpecFluentImpl.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resources.size();i++) { 
    if (predicate.test(resources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
    return setNewResourceLike(index, buildResource(index));
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public A addToSources(int index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);
    if (index < 0 || index >= sources.size()) { _visitables.get("sources").add(builder); sources.add(builder); } else { _visitables.get("sources").add(index, builder); sources.add(index, builder);}
    return (A)this;
  }
  public A setToSources(int index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    SourceSpecBuilder builder = new SourceSpecBuilder(item);
    if (index < 0 || index >= sources.size()) { _visitables.get("sources").add(builder); sources.add(builder); } else { _visitables.get("sources").set(index, builder); sources.set(index, builder);}
    return (A)this;
  }
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(Collection<SourceSpec> items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(Collection<SourceSpec> items) {
    for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<SourceSpecBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      SourceSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getSources() {
    return sources != null ? build(sources) : null;
  }
  public List<SourceSpec> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public SourceSpec buildSource(int index) {
    return this.sources.get(index).build();
  }
  public SourceSpec buildFirstSource() {
    return this.sources.get(0).build();
  }
  public SourceSpec buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<SourceSpec> sources) {
    if (this.sources != null) { _visitables.get("sources").clear();}
    if (sources != null) {this.sources = new ArrayList(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
    if (this.sources != null) {this.sources.clear(); _visitables.remove("sources"); }
    if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> addNewSource() {
    return new IntegrationSpecFluentImpl.SourcesNestedImpl();
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> addNewSourceLike(SourceSpec item) {
    return new IntegrationSpecFluentImpl.SourcesNestedImpl(-1, item);
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> setNewSourceLike(int index,SourceSpec item) {
    return new IntegrationSpecFluentImpl.SourcesNestedImpl(index, item);
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> editSource(int index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public IntegrationSpecFluentImpl.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSpecTemplate getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodSpecTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodSpecTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodSpecTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public IntegrationSpecFluentImpl.TemplateNested<A> withNewTemplate() {
    return new IntegrationSpecFluentImpl.TemplateNestedImpl();
  }
  public IntegrationSpecFluentImpl.TemplateNested<A> withNewTemplateLike(PodSpecTemplate item) {
    return new IntegrationSpecFluentImpl.TemplateNestedImpl(item);
  }
  public IntegrationSpecFluentImpl.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public IntegrationSpecFluentImpl.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodSpecTemplateBuilder().build());
  }
  public IntegrationSpecFluentImpl.TemplateNested<A> editOrNewTemplateLike(PodSpecTemplate item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToTraits(String key,TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(Map<String,TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(Map<String,TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public Map<String,TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(Map<String,TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap(traits);} return (A) this;
  }
  public Boolean hasTraits() {
    return this.traits != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationSpecFluentImpl that = (IntegrationSpecFluentImpl) o;
    if (!java.util.Objects.equals(configuration, that.configuration)) return false;

    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(flows, that.flows)) return false;

    if (!java.util.Objects.equals(integrationKit, that.integrationKit)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(repositories, that.repositories)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(sources, that.sources)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(traits, that.traits)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configuration,  dependencies,  flows,  integrationKit,  profile,  replicas,  repositories,  resources,  serviceAccountName,  sources,  template,  traits,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (flows != null && !flows.isEmpty()) { sb.append("flows:"); sb.append(flows + ","); }
    if (integrationKit != null) { sb.append("integrationKit:"); sb.append(integrationKit + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (repositories != null && !repositories.isEmpty()) { sb.append("repositories:"); sb.append(repositories + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sources != null) { sb.append("sources:"); sb.append(sources + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (traits != null && !traits.isEmpty()) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationSpecFluentImpl.ConfigurationNested<N>> implements IntegrationSpecFluentImpl.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(int index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationSpecBuilder(this);
    }
    ConfigurationSpecBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class IntegrationKitNestedImpl<N> extends ObjectReferenceFluentImpl<IntegrationSpecFluentImpl.IntegrationKitNested<N>> implements IntegrationSpecFluentImpl.IntegrationKitNested<N>,Nested<N>{
    IntegrationKitNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IntegrationKitNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.withIntegrationKit(builder.build());
    }
    public N endIntegrationKit() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceSpecFluentImpl<IntegrationSpecFluentImpl.ResourcesNested<N>> implements IntegrationSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(int index,ResourceSpec item) {
      this.index = index;
      this.builder = new ResourceSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.index = -1;
      this.builder = new ResourceSpecBuilder(this);
    }
    ResourceSpecBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToResources(index,builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  class SourcesNestedImpl<N> extends SourceSpecFluentImpl<IntegrationSpecFluentImpl.SourcesNested<N>> implements IntegrationSpecFluentImpl.SourcesNested<N>,Nested<N>{
    SourcesNestedImpl(int index,SourceSpec item) {
      this.index = index;
      this.builder = new SourceSpecBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new SourceSpecBuilder(this);
    }
    SourceSpecBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodSpecTemplateFluentImpl<IntegrationSpecFluentImpl.TemplateNested<N>> implements IntegrationSpecFluentImpl.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodSpecTemplate item) {
      this.builder = new PodSpecTemplateBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodSpecTemplateBuilder(this);
    }
    PodSpecTemplateBuilder builder;
    public N and() {
      return (N) IntegrationSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}