package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationPlatformStatusFluentImpl<A extends IntegrationPlatformStatusFluent<A>> extends BaseFluent<A> implements IntegrationPlatformStatusFluent<A>{
  public IntegrationPlatformStatusFluentImpl() {
  }
  public IntegrationPlatformStatusFluentImpl(IntegrationPlatformStatus instance) {
    if (instance != null) {
      this.withBuild(instance.getBuild());
      this.withCluster(instance.getCluster());
      this.withConditions(instance.getConditions());
      this.withConfiguration(instance.getConfiguration());
      this.withInfo(instance.getInfo());
      this.withKamelet(instance.getKamelet());
      this.withPhase(instance.getPhase());
      this.withProfile(instance.getProfile());
      this.withResources(instance.getResources());
      this.withTraits(instance.getTraits());
      this.withVersion(instance.getVersion());
    }
  }
  private IntegrationPlatformBuildSpecBuilder build;
  private String cluster;
  private ArrayList<IntegrationPlatformConditionBuilder> conditions = new ArrayList<IntegrationPlatformConditionBuilder>();
  private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList<ConfigurationSpecBuilder>();
  private Map<String,String> info;
  private IntegrationPlatformKameletSpecBuilder kamelet;
  private String phase;
  private String profile;
  private IntegrationPlatformResourcesSpecBuilder resources;
  private Map<String,TraitSpec> traits;
  private String version;
  
  /**
   * This method has been deprecated, please use method buildBuild instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationPlatformBuildSpec getBuild() {
    return this.build!=null ?this.build.build():null;
  }
  public IntegrationPlatformBuildSpec buildBuild() {
    return this.build!=null ?this.build.build():null;
  }
  public A withBuild(IntegrationPlatformBuildSpec build) {
    _visitables.get("build").remove(this.build);
    if (build!=null){ this.build= new IntegrationPlatformBuildSpecBuilder(build); _visitables.get("build").add(this.build);} else { this.build = null; _visitables.get("build").remove(this.build); } return (A) this;
  }
  public Boolean hasBuild() {
    return this.build != null;
  }
  public IntegrationPlatformStatusFluentImpl.BuildNested<A> withNewBuild() {
    return new IntegrationPlatformStatusFluentImpl.BuildNestedImpl();
  }
  public IntegrationPlatformStatusFluentImpl.BuildNested<A> withNewBuildLike(IntegrationPlatformBuildSpec item) {
    return new IntegrationPlatformStatusFluentImpl.BuildNestedImpl(item);
  }
  public IntegrationPlatformStatusFluentImpl.BuildNested<A> editBuild() {
    return withNewBuildLike(getBuild());
  }
  public IntegrationPlatformStatusFluentImpl.BuildNested<A> editOrNewBuild() {
    return withNewBuildLike(getBuild() != null ? getBuild(): new IntegrationPlatformBuildSpecBuilder().build());
  }
  public IntegrationPlatformStatusFluentImpl.BuildNested<A> editOrNewBuildLike(IntegrationPlatformBuildSpec item) {
    return withNewBuildLike(getBuild() != null ? getBuild(): item);
  }
  public String getCluster() {
    return this.cluster;
  }
  public A withCluster(String cluster) {
    this.cluster=cluster; return (A) this;
  }
  public Boolean hasCluster() {
    return this.cluster != null;
  }
  public A addToConditions(int index,IntegrationPlatformCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
    IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,IntegrationPlatformCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
    IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
    for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<IntegrationPlatformCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationPlatformConditionBuilder>();}
    for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... items) {
    for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<IntegrationPlatformCondition> items) {
    for (IntegrationPlatformCondition item : items) {IntegrationPlatformConditionBuilder builder = new IntegrationPlatformConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<IntegrationPlatformConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<IntegrationPlatformConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      IntegrationPlatformConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IntegrationPlatformCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<IntegrationPlatformCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public IntegrationPlatformCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public IntegrationPlatformCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public IntegrationPlatformCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public IntegrationPlatformCondition buildMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
    for (IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
    for (IntegrationPlatformConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<IntegrationPlatformCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (IntegrationPlatformCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.camelk.v1.IntegrationPlatformCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (IntegrationPlatformCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl();
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> addNewConditionLike(IntegrationPlatformCondition item) {
    return new IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,IntegrationPlatformCondition item) {
    return new IntegrationPlatformStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationPlatformStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationPlatformConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").add(index, builder); configuration.add(index, builder);}
    return (A)this;
  }
  public A setToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").set(index, builder); configuration.set(index, builder);}
    return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public List<ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public ConfigurationSpec buildConfiguration(int index) {
    return this.configuration.get(index).build();
  }
  public ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(List<ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").clear();}
    if (configuration != null) {this.configuration = new ArrayList(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear(); _visitables.remove("configuration"); }
    if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl();
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
    return new IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
    return new IntegrationPlatformStatusFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> editConfiguration(int index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationPlatformStatusFluentImpl.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToInfo(String key,String value) {
    if(this.info == null && key != null && value != null) { this.info = new LinkedHashMap(); }
    if(key != null && value != null) {this.info.put(key, value);} return (A)this;
  }
  public A addToInfo(Map<String,String> map) {
    if(this.info == null && map != null) { this.info = new LinkedHashMap(); }
    if(map != null) { this.info.putAll(map);} return (A)this;
  }
  public A removeFromInfo(String key) {
    if(this.info == null) { return (A) this; }
    if(key != null && this.info != null) {this.info.remove(key);} return (A)this;
  }
  public A removeFromInfo(Map<String,String> map) {
    if(this.info == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.info != null){this.info.remove(key);}}} return (A)this;
  }
  public Map<String,String> getInfo() {
    return this.info;
  }
  public <K,V>A withInfo(Map<String,String> info) {
    if (info == null) { this.info =  null;} else {this.info = new LinkedHashMap(info);} return (A) this;
  }
  public Boolean hasInfo() {
    return this.info != null;
  }
  
  /**
   * This method has been deprecated, please use method buildKamelet instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationPlatformKameletSpec getKamelet() {
    return this.kamelet!=null ?this.kamelet.build():null;
  }
  public IntegrationPlatformKameletSpec buildKamelet() {
    return this.kamelet!=null ?this.kamelet.build():null;
  }
  public A withKamelet(IntegrationPlatformKameletSpec kamelet) {
    _visitables.get("kamelet").remove(this.kamelet);
    if (kamelet!=null){ this.kamelet= new IntegrationPlatformKameletSpecBuilder(kamelet); _visitables.get("kamelet").add(this.kamelet);} else { this.kamelet = null; _visitables.get("kamelet").remove(this.kamelet); } return (A) this;
  }
  public Boolean hasKamelet() {
    return this.kamelet != null;
  }
  public IntegrationPlatformStatusFluentImpl.KameletNested<A> withNewKamelet() {
    return new IntegrationPlatformStatusFluentImpl.KameletNestedImpl();
  }
  public IntegrationPlatformStatusFluentImpl.KameletNested<A> withNewKameletLike(IntegrationPlatformKameletSpec item) {
    return new IntegrationPlatformStatusFluentImpl.KameletNestedImpl(item);
  }
  public IntegrationPlatformStatusFluentImpl.KameletNested<A> editKamelet() {
    return withNewKameletLike(getKamelet());
  }
  public IntegrationPlatformStatusFluentImpl.KameletNested<A> editOrNewKamelet() {
    return withNewKameletLike(getKamelet() != null ? getKamelet(): new IntegrationPlatformKameletSpecBuilder().build());
  }
  public IntegrationPlatformStatusFluentImpl.KameletNested<A> editOrNewKameletLike(IntegrationPlatformKameletSpec item) {
    return withNewKameletLike(getKamelet() != null ? getKamelet(): item);
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntegrationPlatformResourcesSpec getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public IntegrationPlatformResourcesSpec buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(IntegrationPlatformResourcesSpec resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new IntegrationPlatformResourcesSpecBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public IntegrationPlatformStatusFluentImpl.ResourcesNested<A> withNewResources() {
    return new IntegrationPlatformStatusFluentImpl.ResourcesNestedImpl();
  }
  public IntegrationPlatformStatusFluentImpl.ResourcesNested<A> withNewResourcesLike(IntegrationPlatformResourcesSpec item) {
    return new IntegrationPlatformStatusFluentImpl.ResourcesNestedImpl(item);
  }
  public IntegrationPlatformStatusFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public IntegrationPlatformStatusFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new IntegrationPlatformResourcesSpecBuilder().build());
  }
  public IntegrationPlatformStatusFluentImpl.ResourcesNested<A> editOrNewResourcesLike(IntegrationPlatformResourcesSpec item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public A addToTraits(String key,TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(Map<String,TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(Map<String,TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public Map<String,TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(Map<String,TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap(traits);} return (A) this;
  }
  public Boolean hasTraits() {
    return this.traits != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationPlatformStatusFluentImpl that = (IntegrationPlatformStatusFluentImpl) o;
    if (!java.util.Objects.equals(build, that.build)) return false;

    if (!java.util.Objects.equals(cluster, that.cluster)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(configuration, that.configuration)) return false;

    if (!java.util.Objects.equals(info, that.info)) return false;

    if (!java.util.Objects.equals(kamelet, that.kamelet)) return false;

    if (!java.util.Objects.equals(phase, that.phase)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(traits, that.traits)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(build,  cluster,  conditions,  configuration,  info,  kamelet,  phase,  profile,  resources,  traits,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (build != null) { sb.append("build:"); sb.append(build + ","); }
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (info != null && !info.isEmpty()) { sb.append("info:"); sb.append(info + ","); }
    if (kamelet != null) { sb.append("kamelet:"); sb.append(kamelet + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (traits != null && !traits.isEmpty()) { sb.append("traits:"); sb.append(traits + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class BuildNestedImpl<N> extends IntegrationPlatformBuildSpecFluentImpl<IntegrationPlatformStatusFluentImpl.BuildNested<N>> implements IntegrationPlatformStatusFluentImpl.BuildNested<N>,Nested<N>{
    BuildNestedImpl(IntegrationPlatformBuildSpec item) {
      this.builder = new IntegrationPlatformBuildSpecBuilder(this, item);
    }
    BuildNestedImpl() {
      this.builder = new IntegrationPlatformBuildSpecBuilder(this);
    }
    IntegrationPlatformBuildSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformStatusFluentImpl.this.withBuild(builder.build());
    }
    public N endBuild() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends IntegrationPlatformConditionFluentImpl<IntegrationPlatformStatusFluentImpl.ConditionsNested<N>> implements IntegrationPlatformStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,IntegrationPlatformCondition item) {
      this.index = index;
      this.builder = new IntegrationPlatformConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new IntegrationPlatformConditionBuilder(this);
    }
    IntegrationPlatformConditionBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationPlatformStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationPlatformStatusFluentImpl.ConfigurationNested<N>> implements IntegrationPlatformStatusFluentImpl.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(int index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationSpecBuilder(this);
    }
    ConfigurationSpecBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationPlatformStatusFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  class KameletNestedImpl<N> extends IntegrationPlatformKameletSpecFluentImpl<IntegrationPlatformStatusFluentImpl.KameletNested<N>> implements IntegrationPlatformStatusFluentImpl.KameletNested<N>,Nested<N>{
    KameletNestedImpl(IntegrationPlatformKameletSpec item) {
      this.builder = new IntegrationPlatformKameletSpecBuilder(this, item);
    }
    KameletNestedImpl() {
      this.builder = new IntegrationPlatformKameletSpecBuilder(this);
    }
    IntegrationPlatformKameletSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformStatusFluentImpl.this.withKamelet(builder.build());
    }
    public N endKamelet() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends IntegrationPlatformResourcesSpecFluentImpl<IntegrationPlatformStatusFluentImpl.ResourcesNested<N>> implements IntegrationPlatformStatusFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(IntegrationPlatformResourcesSpec item) {
      this.builder = new IntegrationPlatformResourcesSpecBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new IntegrationPlatformResourcesSpecBuilder(this);
    }
    IntegrationPlatformResourcesSpecBuilder builder;
    public N and() {
      return (N) IntegrationPlatformStatusFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}