package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformSpecBuilder extends IntegrationPlatformSpecFluentImpl<IntegrationPlatformSpecBuilder> implements VisitableBuilder<IntegrationPlatformSpec,IntegrationPlatformSpecBuilder>{
  public IntegrationPlatformSpecBuilder() {
    this(false);
  }
  public IntegrationPlatformSpecBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformSpec(), validationEnabled);
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformSpec(), validationEnabled);
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,IntegrationPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpecFluent<?> fluent,IntegrationPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBuild(instance.getBuild());
      fluent.withCluster(instance.getCluster());
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withKamelet(instance.getKamelet());
      fluent.withProfile(instance.getProfile());
      fluent.withResources(instance.getResources());
      fluent.withTraits(instance.getTraits());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpec instance) {
    this(instance,false);
  }
  public IntegrationPlatformSpecBuilder(IntegrationPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBuild(instance.getBuild());
      this.withCluster(instance.getCluster());
      this.withConfiguration(instance.getConfiguration());
      this.withKamelet(instance.getKamelet());
      this.withProfile(instance.getProfile());
      this.withResources(instance.getResources());
      this.withTraits(instance.getTraits());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationPlatformSpec build() {
    IntegrationPlatformSpec buildable = new IntegrationPlatformSpec(fluent.getBuild(),fluent.getCluster(),fluent.getConfiguration(),fluent.getKamelet(),fluent.getProfile(),fluent.getResources(),fluent.getTraits());
    return buildable;
  }
  
}