package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationPlatformListBuilder extends IntegrationPlatformListFluentImpl<IntegrationPlatformListBuilder> implements VisitableBuilder<IntegrationPlatformList,IntegrationPlatformListBuilder>{
  public IntegrationPlatformListBuilder() {
    this(false);
  }
  public IntegrationPlatformListBuilder(Boolean validationEnabled) {
    this(new IntegrationPlatformList(), validationEnabled);
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationPlatformList(), validationEnabled);
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,IntegrationPlatformList instance) {
    this(fluent, instance, false);
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,IntegrationPlatformList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformList instance) {
    this(instance,false);
  }
  public IntegrationPlatformListBuilder(IntegrationPlatformList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationPlatformListFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationPlatformList build() {
    IntegrationPlatformList buildable = new IntegrationPlatformList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}