package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationKitStatusFluentImpl<A extends IntegrationKitStatusFluent<A>> extends BaseFluent<A> implements IntegrationKitStatusFluent<A>{
  public IntegrationKitStatusFluentImpl() {
  }
  public IntegrationKitStatusFluentImpl(IntegrationKitStatus instance) {
    if (instance != null) {
      this.withArtifacts(instance.getArtifacts());
      this.withBaseImage(instance.getBaseImage());
      this.withConditions(instance.getConditions());
      this.withDigest(instance.getDigest());
      this.withFailure(instance.getFailure());
      this.withImage(instance.getImage());
      this.withPhase(instance.getPhase());
      this.withPlatform(instance.getPlatform());
      this.withRuntimeProvider(instance.getRuntimeProvider());
      this.withRuntimeVersion(instance.getRuntimeVersion());
      this.withVersion(instance.getVersion());
    }
  }
  private ArrayList<ArtifactBuilder> artifacts = new ArrayList<ArtifactBuilder>();
  private String baseImage;
  private ArrayList<IntegrationKitConditionBuilder> conditions = new ArrayList<IntegrationKitConditionBuilder>();
  private String digest;
  private FailureBuilder failure;
  private String image;
  private String phase;
  private String platform;
  private String runtimeProvider;
  private String runtimeVersion;
  private String version;
  public A addToArtifacts(int index,Artifact item) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
    ArtifactBuilder builder = new ArtifactBuilder(item);
    if (index < 0 || index >= artifacts.size()) { _visitables.get("artifacts").add(builder); artifacts.add(builder); } else { _visitables.get("artifacts").add(index, builder); artifacts.add(index, builder);}
    return (A)this;
  }
  public A setToArtifacts(int index,Artifact item) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
    ArtifactBuilder builder = new ArtifactBuilder(item);
    if (index < 0 || index >= artifacts.size()) { _visitables.get("artifacts").add(builder); artifacts.add(builder); } else { _visitables.get("artifacts").set(index, builder); artifacts.set(index, builder);}
    return (A)this;
  }
  public A addToArtifacts(io.fabric8.camelk.v1.Artifact... items) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
    for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
  }
  public A addAllToArtifacts(Collection<Artifact> items) {
    if (this.artifacts == null) {this.artifacts = new ArrayList<ArtifactBuilder>();}
    for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
  }
  public A removeFromArtifacts(io.fabric8.camelk.v1.Artifact... items) {
    for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
  }
  public A removeAllFromArtifacts(Collection<Artifact> items) {
    for (Artifact item : items) {ArtifactBuilder builder = new ArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate) {
    if (artifacts == null) return (A) this;
    final Iterator<ArtifactBuilder> each = artifacts.iterator();
    final List visitables = _visitables.get("artifacts");
    while (each.hasNext()) {
      ArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildArtifacts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Artifact> getArtifacts() {
    return artifacts != null ? build(artifacts) : null;
  }
  public List<Artifact> buildArtifacts() {
    return artifacts != null ? build(artifacts) : null;
  }
  public Artifact buildArtifact(int index) {
    return this.artifacts.get(index).build();
  }
  public Artifact buildFirstArtifact() {
    return this.artifacts.get(0).build();
  }
  public Artifact buildLastArtifact() {
    return this.artifacts.get(artifacts.size() - 1).build();
  }
  public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
    for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
    for (ArtifactBuilder item: artifacts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withArtifacts(List<Artifact> artifacts) {
    if (this.artifacts != null) { _visitables.get("artifacts").clear();}
    if (artifacts != null) {this.artifacts = new ArrayList(); for (Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
  }
  public A withArtifacts(io.fabric8.camelk.v1.Artifact... artifacts) {
    if (this.artifacts != null) {this.artifacts.clear(); _visitables.remove("artifacts"); }
    if (artifacts != null) {for (Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
  }
  public Boolean hasArtifacts() {
    return artifacts != null && !artifacts.isEmpty();
  }
  public A addNewArtifact(String checksum,String id,String location,String target) {
    return (A)addToArtifacts(new Artifact(checksum, id, location, target));
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> addNewArtifact() {
    return new IntegrationKitStatusFluentImpl.ArtifactsNestedImpl();
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> addNewArtifactLike(Artifact item) {
    return new IntegrationKitStatusFluentImpl.ArtifactsNestedImpl(-1, item);
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item) {
    return new IntegrationKitStatusFluentImpl.ArtifactsNestedImpl(index, item);
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> editArtifact(int index) {
    if (artifacts.size() <= index) throw new RuntimeException("Can't edit artifacts. Index exceeds size.");
    return setNewArtifactLike(index, buildArtifact(index));
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> editFirstArtifact() {
    if (artifacts.size() == 0) throw new RuntimeException("Can't edit first artifacts. The list is empty.");
    return setNewArtifactLike(0, buildArtifact(0));
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> editLastArtifact() {
    int index = artifacts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last artifacts. The list is empty.");
    return setNewArtifactLike(index, buildArtifact(index));
  }
  public IntegrationKitStatusFluentImpl.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<artifacts.size();i++) { 
    if (predicate.test(artifacts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching artifacts. No match found.");
    return setNewArtifactLike(index, buildArtifact(index));
  }
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  public A addToConditions(int index,IntegrationKitCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
    IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,IntegrationKitCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
    IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.camelk.v1.IntegrationKitCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
    for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<IntegrationKitCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IntegrationKitConditionBuilder>();}
    for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.camelk.v1.IntegrationKitCondition... items) {
    for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<IntegrationKitCondition> items) {
    for (IntegrationKitCondition item : items) {IntegrationKitConditionBuilder builder = new IntegrationKitConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<IntegrationKitConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<IntegrationKitConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      IntegrationKitConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IntegrationKitCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<IntegrationKitCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public IntegrationKitCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public IntegrationKitCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public IntegrationKitCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public IntegrationKitCondition buildMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
    for (IntegrationKitConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
    for (IntegrationKitConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<IntegrationKitCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (IntegrationKitCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.camelk.v1.IntegrationKitCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (IntegrationKitCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new IntegrationKitStatusFluentImpl.ConditionsNestedImpl();
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> addNewConditionLike(IntegrationKitCondition item) {
    return new IntegrationKitStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,IntegrationKitCondition item) {
    return new IntegrationKitStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IntegrationKitStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationKitConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getDigest() {
    return this.digest;
  }
  public A withDigest(String digest) {
    this.digest=digest; return (A) this;
  }
  public Boolean hasDigest() {
    return this.digest != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFailure instead.
   * @return The buildable object.
   */
  @Deprecated
  public Failure getFailure() {
    return this.failure!=null ?this.failure.build():null;
  }
  public Failure buildFailure() {
    return this.failure!=null ?this.failure.build():null;
  }
  public A withFailure(Failure failure) {
    _visitables.get("failure").remove(this.failure);
    if (failure!=null){ this.failure= new FailureBuilder(failure); _visitables.get("failure").add(this.failure);} else { this.failure = null; _visitables.get("failure").remove(this.failure); } return (A) this;
  }
  public Boolean hasFailure() {
    return this.failure != null;
  }
  public IntegrationKitStatusFluentImpl.FailureNested<A> withNewFailure() {
    return new IntegrationKitStatusFluentImpl.FailureNestedImpl();
  }
  public IntegrationKitStatusFluentImpl.FailureNested<A> withNewFailureLike(Failure item) {
    return new IntegrationKitStatusFluentImpl.FailureNestedImpl(item);
  }
  public IntegrationKitStatusFluentImpl.FailureNested<A> editFailure() {
    return withNewFailureLike(getFailure());
  }
  public IntegrationKitStatusFluentImpl.FailureNested<A> editOrNewFailure() {
    return withNewFailureLike(getFailure() != null ? getFailure(): new FailureBuilder().build());
  }
  public IntegrationKitStatusFluentImpl.FailureNested<A> editOrNewFailureLike(Failure item) {
    return withNewFailureLike(getFailure() != null ? getFailure(): item);
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public String getPlatform() {
    return this.platform;
  }
  public A withPlatform(String platform) {
    this.platform=platform; return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public String getRuntimeProvider() {
    return this.runtimeProvider;
  }
  public A withRuntimeProvider(String runtimeProvider) {
    this.runtimeProvider=runtimeProvider; return (A) this;
  }
  public Boolean hasRuntimeProvider() {
    return this.runtimeProvider != null;
  }
  public String getRuntimeVersion() {
    return this.runtimeVersion;
  }
  public A withRuntimeVersion(String runtimeVersion) {
    this.runtimeVersion=runtimeVersion; return (A) this;
  }
  public Boolean hasRuntimeVersion() {
    return this.runtimeVersion != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationKitStatusFluentImpl that = (IntegrationKitStatusFluentImpl) o;
    if (!java.util.Objects.equals(artifacts, that.artifacts)) return false;

    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(digest, that.digest)) return false;

    if (!java.util.Objects.equals(failure, that.failure)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(phase, that.phase)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(runtimeProvider, that.runtimeProvider)) return false;

    if (!java.util.Objects.equals(runtimeVersion, that.runtimeVersion)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifacts,  baseImage,  conditions,  digest,  failure,  image,  phase,  platform,  runtimeProvider,  runtimeVersion,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (artifacts != null) { sb.append("artifacts:"); sb.append(artifacts + ","); }
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (digest != null) { sb.append("digest:"); sb.append(digest + ","); }
    if (failure != null) { sb.append("failure:"); sb.append(failure + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (runtimeProvider != null) { sb.append("runtimeProvider:"); sb.append(runtimeProvider + ","); }
    if (runtimeVersion != null) { sb.append("runtimeVersion:"); sb.append(runtimeVersion + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ArtifactsNestedImpl<N> extends ArtifactFluentImpl<IntegrationKitStatusFluentImpl.ArtifactsNested<N>> implements IntegrationKitStatusFluentImpl.ArtifactsNested<N>,Nested<N>{
    ArtifactsNestedImpl(int index,Artifact item) {
      this.index = index;
      this.builder = new ArtifactBuilder(this, item);
    }
    ArtifactsNestedImpl() {
      this.index = -1;
      this.builder = new ArtifactBuilder(this);
    }
    ArtifactBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationKitStatusFluentImpl.this.setToArtifacts(index,builder.build());
    }
    public N endArtifact() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends IntegrationKitConditionFluentImpl<IntegrationKitStatusFluentImpl.ConditionsNested<N>> implements IntegrationKitStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,IntegrationKitCondition item) {
      this.index = index;
      this.builder = new IntegrationKitConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new IntegrationKitConditionBuilder(this);
    }
    IntegrationKitConditionBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationKitStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class FailureNestedImpl<N> extends FailureFluentImpl<IntegrationKitStatusFluentImpl.FailureNested<N>> implements IntegrationKitStatusFluentImpl.FailureNested<N>,Nested<N>{
    FailureNestedImpl(Failure item) {
      this.builder = new FailureBuilder(this, item);
    }
    FailureNestedImpl() {
      this.builder = new FailureBuilder(this);
    }
    FailureBuilder builder;
    public N and() {
      return (N) IntegrationKitStatusFluentImpl.this.withFailure(builder.build());
    }
    public N endFailure() {
      return and();
    }
    
  }
  
}