package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitStatusBuilder extends IntegrationKitStatusFluentImpl<IntegrationKitStatusBuilder> implements VisitableBuilder<IntegrationKitStatus,IntegrationKitStatusBuilder>{
  public IntegrationKitStatusBuilder() {
    this(false);
  }
  public IntegrationKitStatusBuilder(Boolean validationEnabled) {
    this(new IntegrationKitStatus(), validationEnabled);
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationKitStatus(), validationEnabled);
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,IntegrationKitStatus instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatusFluent<?> fluent,IntegrationKitStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withArtifacts(instance.getArtifacts());
      fluent.withBaseImage(instance.getBaseImage());
      fluent.withConditions(instance.getConditions());
      fluent.withDigest(instance.getDigest());
      fluent.withFailure(instance.getFailure());
      fluent.withImage(instance.getImage());
      fluent.withPhase(instance.getPhase());
      fluent.withPlatform(instance.getPlatform());
      fluent.withRuntimeProvider(instance.getRuntimeProvider());
      fluent.withRuntimeVersion(instance.getRuntimeVersion());
      fluent.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatus instance) {
    this(instance,false);
  }
  public IntegrationKitStatusBuilder(IntegrationKitStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withArtifacts(instance.getArtifacts());
      this.withBaseImage(instance.getBaseImage());
      this.withConditions(instance.getConditions());
      this.withDigest(instance.getDigest());
      this.withFailure(instance.getFailure());
      this.withImage(instance.getImage());
      this.withPhase(instance.getPhase());
      this.withPlatform(instance.getPlatform());
      this.withRuntimeProvider(instance.getRuntimeProvider());
      this.withRuntimeVersion(instance.getRuntimeVersion());
      this.withVersion(instance.getVersion());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationKitStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationKitStatus build() {
    IntegrationKitStatus buildable = new IntegrationKitStatus(fluent.getArtifacts(),fluent.getBaseImage(),fluent.getConditions(),fluent.getDigest(),fluent.getFailure(),fluent.getImage(),fluent.getPhase(),fluent.getPlatform(),fluent.getRuntimeProvider(),fluent.getRuntimeVersion(),fluent.getVersion());
    return buildable;
  }
  
}