package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IntegrationKitSpecFluentImpl<A extends IntegrationKitSpecFluent<A>> extends BaseFluent<A> implements IntegrationKitSpecFluent<A>{
  public IntegrationKitSpecFluentImpl() {
  }
  public IntegrationKitSpecFluentImpl(IntegrationKitSpec instance) {
    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withDependencies(instance.getDependencies());
      this.withImage(instance.getImage());
      this.withProfile(instance.getProfile());
      this.withRepositories(instance.getRepositories());
      this.withTraits(instance.getTraits());
    }
  }
  private ArrayList<ConfigurationSpecBuilder> configuration = new ArrayList<ConfigurationSpecBuilder>();
  private List<String> dependencies = new ArrayList<String>();
  private String image;
  private String profile;
  private List<String> repositories = new ArrayList<String>();
  private Map<String,TraitSpec> traits;
  public A addToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").add(index, builder); configuration.add(index, builder);}
    return (A)this;
  }
  public A setToConfiguration(int index,ConfigurationSpec item) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
    if (index < 0 || index >= configuration.size()) { _visitables.get("configuration").add(builder); configuration.add(builder); } else { _visitables.get("configuration").set(index, builder); configuration.set(index, builder);}
    return (A)this;
  }
  public A addToConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
    if (this.configuration == null) {this.configuration = new ArrayList<ConfigurationSpecBuilder>();}
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").add(builder);this.configuration.add(builder);} return (A)this;
  }
  public A removeFromConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
    for (ConfigurationSpec item : items) {ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);_visitables.get("configuration").remove(builder);if (this.configuration != null) {this.configuration.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    if (configuration == null) return (A) this;
    final Iterator<ConfigurationSpecBuilder> each = configuration.iterator();
    final List visitables = _visitables.get("configuration");
    while (each.hasNext()) {
      ConfigurationSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConfigurationSpec> getConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public List<ConfigurationSpec> buildConfiguration() {
    return configuration != null ? build(configuration) : null;
  }
  public ConfigurationSpec buildConfiguration(int index) {
    return this.configuration.get(index).build();
  }
  public ConfigurationSpec buildFirstConfiguration() {
    return this.configuration.get(0).build();
  }
  public ConfigurationSpec buildLastConfiguration() {
    return this.configuration.get(configuration.size() - 1).build();
  }
  public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    for (ConfigurationSpecBuilder item: configuration) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConfiguration(List<ConfigurationSpec> configuration) {
    if (this.configuration != null) { _visitables.get("configuration").clear();}
    if (configuration != null) {this.configuration = new ArrayList(); for (ConfigurationSpec item : configuration){this.addToConfiguration(item);}} else { this.configuration = null;} return (A) this;
  }
  public A withConfiguration(io.fabric8.camelk.v1.ConfigurationSpec... configuration) {
    if (this.configuration != null) {this.configuration.clear(); _visitables.remove("configuration"); }
    if (configuration != null) {for (ConfigurationSpec item :configuration){ this.addToConfiguration(item);}} return (A) this;
  }
  public Boolean hasConfiguration() {
    return configuration != null && !configuration.isEmpty();
  }
  public A addNewConfiguration(String resourceKey,String resourceMountPoint,String resourceType,String type,String value) {
    return (A)addToConfiguration(new ConfigurationSpec(resourceKey, resourceMountPoint, resourceType, type, value));
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> addNewConfiguration() {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl();
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl(-1, item);
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> setNewConfigurationLike(int index,ConfigurationSpec item) {
    return new IntegrationKitSpecFluentImpl.ConfigurationNestedImpl(index, item);
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> editConfiguration(int index) {
    if (configuration.size() <= index) throw new RuntimeException("Can't edit configuration. Index exceeds size.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> editFirstConfiguration() {
    if (configuration.size() == 0) throw new RuntimeException("Can't edit first configuration. The list is empty.");
    return setNewConfigurationLike(0, buildConfiguration(0));
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> editLastConfiguration() {
    int index = configuration.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last configuration. The list is empty.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public IntegrationKitSpecFluentImpl.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<configuration.size();i++) { 
    if (predicate.test(configuration.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching configuration. No match found.");
    return setNewConfigurationLike(index, buildConfiguration(index));
  }
  public A addToDependencies(int index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(int index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(int index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public Boolean hasProfile() {
    return this.profile != null;
  }
  public A addToRepositories(int index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.add(index, item);
    return (A)this;
  }
  public A setToRepositories(int index,String item) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    this.repositories.set(index, item); return (A)this;
  }
  public A addToRepositories(java.lang.String... items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A addAllToRepositories(Collection<String> items) {
    if (this.repositories == null) {this.repositories = new ArrayList<String>();}
    for (String item : items) {this.repositories.add(item);} return (A)this;
  }
  public A removeFromRepositories(java.lang.String... items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public A removeAllFromRepositories(Collection<String> items) {
    for (String item : items) {if (this.repositories!= null){ this.repositories.remove(item);}} return (A)this;
  }
  public List<String> getRepositories() {
    return this.repositories;
  }
  public String getRepository(int index) {
    return this.repositories.get(index);
  }
  public String getFirstRepository() {
    return this.repositories.get(0);
  }
  public String getLastRepository() {
    return this.repositories.get(repositories.size() - 1);
  }
  public String getMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRepository(Predicate<String> predicate) {
    for (String item: repositories) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRepositories(List<String> repositories) {
    if (repositories != null) {this.repositories = new ArrayList(); for (String item : repositories){this.addToRepositories(item);}} else { this.repositories = null;} return (A) this;
  }
  public A withRepositories(java.lang.String... repositories) {
    if (this.repositories != null) {this.repositories.clear(); _visitables.remove("repositories"); }
    if (repositories != null) {for (String item :repositories){ this.addToRepositories(item);}} return (A) this;
  }
  public Boolean hasRepositories() {
    return repositories != null && !repositories.isEmpty();
  }
  public A addToTraits(String key,TraitSpec value) {
    if(this.traits == null && key != null && value != null) { this.traits = new LinkedHashMap(); }
    if(key != null && value != null) {this.traits.put(key, value);} return (A)this;
  }
  public A addToTraits(Map<String,TraitSpec> map) {
    if(this.traits == null && map != null) { this.traits = new LinkedHashMap(); }
    if(map != null) { this.traits.putAll(map);} return (A)this;
  }
  public A removeFromTraits(String key) {
    if(this.traits == null) { return (A) this; }
    if(key != null && this.traits != null) {this.traits.remove(key);} return (A)this;
  }
  public A removeFromTraits(Map<String,TraitSpec> map) {
    if(this.traits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.traits != null){this.traits.remove(key);}}} return (A)this;
  }
  public Map<String,TraitSpec> getTraits() {
    return this.traits;
  }
  public <K,V>A withTraits(Map<String,TraitSpec> traits) {
    if (traits == null) { this.traits =  null;} else {this.traits = new LinkedHashMap(traits);} return (A) this;
  }
  public Boolean hasTraits() {
    return this.traits != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationKitSpecFluentImpl that = (IntegrationKitSpecFluentImpl) o;
    if (!java.util.Objects.equals(configuration, that.configuration)) return false;

    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(repositories, that.repositories)) return false;

    if (!java.util.Objects.equals(traits, that.traits)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configuration,  dependencies,  image,  profile,  repositories,  traits,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (repositories != null && !repositories.isEmpty()) { sb.append("repositories:"); sb.append(repositories + ","); }
    if (traits != null && !traits.isEmpty()) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigurationNestedImpl<N> extends ConfigurationSpecFluentImpl<IntegrationKitSpecFluentImpl.ConfigurationNested<N>> implements IntegrationKitSpecFluentImpl.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(int index,ConfigurationSpec item) {
      this.index = index;
      this.builder = new ConfigurationSpecBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.index = -1;
      this.builder = new ConfigurationSpecBuilder(this);
    }
    ConfigurationSpecBuilder builder;
    int index;
    public N and() {
      return (N) IntegrationKitSpecFluentImpl.this.setToConfiguration(index,builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  
}