package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitSpecBuilder extends IntegrationKitSpecFluentImpl<IntegrationKitSpecBuilder> implements VisitableBuilder<IntegrationKitSpec,IntegrationKitSpecBuilder>{
  public IntegrationKitSpecBuilder() {
    this(false);
  }
  public IntegrationKitSpecBuilder(Boolean validationEnabled) {
    this(new IntegrationKitSpec(), validationEnabled);
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationKitSpec(), validationEnabled);
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpecFluent<?> fluent,IntegrationKitSpec instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpecFluent<?> fluent,IntegrationKitSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withDependencies(instance.getDependencies());
      fluent.withImage(instance.getImage());
      fluent.withProfile(instance.getProfile());
      fluent.withRepositories(instance.getRepositories());
      fluent.withTraits(instance.getTraits());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpec instance) {
    this(instance,false);
  }
  public IntegrationKitSpecBuilder(IntegrationKitSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfiguration(instance.getConfiguration());
      this.withDependencies(instance.getDependencies());
      this.withImage(instance.getImage());
      this.withProfile(instance.getProfile());
      this.withRepositories(instance.getRepositories());
      this.withTraits(instance.getTraits());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationKitSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationKitSpec build() {
    IntegrationKitSpec buildable = new IntegrationKitSpec(fluent.getConfiguration(),fluent.getDependencies(),fluent.getImage(),fluent.getProfile(),fluent.getRepositories(),fluent.getTraits());
    return buildable;
  }
  
}