package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitListBuilder extends IntegrationKitListFluentImpl<IntegrationKitListBuilder> implements VisitableBuilder<IntegrationKitList,IntegrationKitListBuilder>{
  public IntegrationKitListBuilder() {
    this(false);
  }
  public IntegrationKitListBuilder(Boolean validationEnabled) {
    this(new IntegrationKitList(), validationEnabled);
  }
  public IntegrationKitListBuilder(IntegrationKitListFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitListBuilder(IntegrationKitListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationKitList(), validationEnabled);
  }
  public IntegrationKitListBuilder(IntegrationKitListFluent<?> fluent,IntegrationKitList instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitListBuilder(IntegrationKitListFluent<?> fluent,IntegrationKitList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitListBuilder(IntegrationKitList instance) {
    this(instance,false);
  }
  public IntegrationKitListBuilder(IntegrationKitList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationKitListFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationKitList build() {
    IntegrationKitList buildable = new IntegrationKitList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}