package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntegrationKitConditionBuilder extends IntegrationKitConditionFluentImpl<IntegrationKitConditionBuilder> implements VisitableBuilder<IntegrationKitCondition,IntegrationKitConditionBuilder>{
  public IntegrationKitConditionBuilder() {
    this(false);
  }
  public IntegrationKitConditionBuilder(Boolean validationEnabled) {
    this(new IntegrationKitCondition(), validationEnabled);
  }
  public IntegrationKitConditionBuilder(IntegrationKitConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IntegrationKitConditionBuilder(IntegrationKitConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntegrationKitCondition(), validationEnabled);
  }
  public IntegrationKitConditionBuilder(IntegrationKitConditionFluent<?> fluent,IntegrationKitCondition instance) {
    this(fluent, instance, false);
  }
  public IntegrationKitConditionBuilder(IntegrationKitConditionFluent<?> fluent,IntegrationKitCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IntegrationKitConditionBuilder(IntegrationKitCondition instance) {
    this(instance,false);
  }
  public IntegrationKitConditionBuilder(IntegrationKitCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  IntegrationKitConditionFluent<?> fluent;
  Boolean validationEnabled;
  public IntegrationKitCondition build() {
    IntegrationKitCondition buildable = new IntegrationKitCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}