package io.fabric8.camelk.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FailureFluentImpl<A extends FailureFluent<A>> extends BaseFluent<A> implements FailureFluent<A>{
  public FailureFluentImpl() {
  }
  public FailureFluentImpl(Failure instance) {
    if (instance != null) {
      this.withReason(instance.getReason());
      this.withRecovery(instance.getRecovery());
      this.withTime(instance.getTime());
    }
  }
  private String reason;
  private FailureRecoveryBuilder recovery;
  private String time;
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRecovery instead.
   * @return The buildable object.
   */
  @Deprecated
  public FailureRecovery getRecovery() {
    return this.recovery!=null ?this.recovery.build():null;
  }
  public FailureRecovery buildRecovery() {
    return this.recovery!=null ?this.recovery.build():null;
  }
  public A withRecovery(FailureRecovery recovery) {
    _visitables.get("recovery").remove(this.recovery);
    if (recovery!=null){ this.recovery= new FailureRecoveryBuilder(recovery); _visitables.get("recovery").add(this.recovery);} else { this.recovery = null; _visitables.get("recovery").remove(this.recovery); } return (A) this;
  }
  public Boolean hasRecovery() {
    return this.recovery != null;
  }
  public A withNewRecovery(Integer attempt,Integer attemptMax,String attemptTime) {
    return (A)withRecovery(new FailureRecovery(attempt, attemptMax, attemptTime));
  }
  public FailureFluentImpl.RecoveryNested<A> withNewRecovery() {
    return new FailureFluentImpl.RecoveryNestedImpl();
  }
  public FailureFluentImpl.RecoveryNested<A> withNewRecoveryLike(FailureRecovery item) {
    return new FailureFluentImpl.RecoveryNestedImpl(item);
  }
  public FailureFluentImpl.RecoveryNested<A> editRecovery() {
    return withNewRecoveryLike(getRecovery());
  }
  public FailureFluentImpl.RecoveryNested<A> editOrNewRecovery() {
    return withNewRecoveryLike(getRecovery() != null ? getRecovery(): new FailureRecoveryBuilder().build());
  }
  public FailureFluentImpl.RecoveryNested<A> editOrNewRecoveryLike(FailureRecovery item) {
    return withNewRecoveryLike(getRecovery() != null ? getRecovery(): item);
  }
  public String getTime() {
    return this.time;
  }
  public A withTime(String time) {
    this.time=time; return (A) this;
  }
  public Boolean hasTime() {
    return this.time != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FailureFluentImpl that = (FailureFluentImpl) o;
    if (!java.util.Objects.equals(reason, that.reason)) return false;

    if (!java.util.Objects.equals(recovery, that.recovery)) return false;

    if (!java.util.Objects.equals(time, that.time)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(reason,  recovery,  time,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (recovery != null) { sb.append("recovery:"); sb.append(recovery + ","); }
    if (time != null) { sb.append("time:"); sb.append(time); }
    sb.append("}");
    return sb.toString();
  }
  class RecoveryNestedImpl<N> extends FailureRecoveryFluentImpl<FailureFluentImpl.RecoveryNested<N>> implements FailureFluentImpl.RecoveryNested<N>,Nested<N>{
    RecoveryNestedImpl(FailureRecovery item) {
      this.builder = new FailureRecoveryBuilder(this, item);
    }
    RecoveryNestedImpl() {
      this.builder = new FailureRecoveryBuilder(this);
    }
    FailureRecoveryBuilder builder;
    public N and() {
      return (N) FailureFluentImpl.this.withRecovery(builder.build());
    }
    public N endRecovery() {
      return and();
    }
    
  }
  
}