package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailureBuilder extends FailureFluentImpl<FailureBuilder> implements VisitableBuilder<Failure,FailureBuilder>{
  public FailureBuilder() {
    this(false);
  }
  public FailureBuilder(Boolean validationEnabled) {
    this(new Failure(), validationEnabled);
  }
  public FailureBuilder(FailureFluent<?> fluent) {
    this(fluent, false);
  }
  public FailureBuilder(FailureFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Failure(), validationEnabled);
  }
  public FailureBuilder(FailureFluent<?> fluent,Failure instance) {
    this(fluent, instance, false);
  }
  public FailureBuilder(FailureFluent<?> fluent,Failure instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withReason(instance.getReason());
      fluent.withRecovery(instance.getRecovery());
      fluent.withTime(instance.getTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FailureBuilder(Failure instance) {
    this(instance,false);
  }
  public FailureBuilder(Failure instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withReason(instance.getReason());
      this.withRecovery(instance.getRecovery());
      this.withTime(instance.getTime());
    }
    this.validationEnabled = validationEnabled; 
  }
  FailureFluent<?> fluent;
  Boolean validationEnabled;
  public Failure build() {
    Failure buildable = new Failure(fluent.getReason(),fluent.getRecovery(),fluent.getTime());
    return buildable;
  }
  
}