package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CapabilityFluentImpl<A extends CapabilityFluent<A>> extends BaseFluent<A> implements CapabilityFluent<A>{
  public CapabilityFluentImpl() {
  }
  public CapabilityFluentImpl(Capability instance) {
    if (instance != null) {
      this.withDependencies(instance.getDependencies());
      this.withMetadata(instance.getMetadata());
    }
  }
  private ArrayList<MavenArtifactBuilder> dependencies = new ArrayList<MavenArtifactBuilder>();
  private Map<String,String> metadata;
  public A addToDependencies(int index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  public A setToDependencies(int index,MavenArtifact item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<MavenArtifact> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<MavenArtifactBuilder>();}
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.MavenArtifact... items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<MavenArtifact> items) {
    for (MavenArtifact item : items) {MavenArtifactBuilder builder = new MavenArtifactBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<MavenArtifactBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      MavenArtifactBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public List<MavenArtifact> buildDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public MavenArtifact buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  public MavenArtifact buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public MavenArtifact buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    for (MavenArtifactBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<MavenArtifact> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").clear();}
    if (dependencies != null) {this.dependencies = new ArrayList(); for (MavenArtifact item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.MavenArtifact... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (MavenArtifact item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(String artifactId,String groupId,String version) {
    return (A)addToDependencies(new MavenArtifact(artifactId, groupId, version));
  }
  public CapabilityFluentImpl.DependenciesNested<A> addNewDependency() {
    return new CapabilityFluentImpl.DependenciesNestedImpl();
  }
  public CapabilityFluentImpl.DependenciesNested<A> addNewDependencyLike(MavenArtifact item) {
    return new CapabilityFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public CapabilityFluentImpl.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item) {
    return new CapabilityFluentImpl.DependenciesNestedImpl(index, item);
  }
  public CapabilityFluentImpl.DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CapabilityFluentImpl.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public CapabilityFluentImpl.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CapabilityFluentImpl.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A addToMetadata(String key,String value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  public A addToMetadata(Map<String,String> map) {
    if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  public A removeFromMetadata(String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  public A removeFromMetadata(Map<String,String> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMetadata() {
    return this.metadata;
  }
  public <K,V>A withMetadata(Map<String,String> metadata) {
    if (metadata == null) { this.metadata =  null;} else {this.metadata = new LinkedHashMap(metadata);} return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CapabilityFluentImpl that = (CapabilityFluentImpl) o;
    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dependencies,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dependencies != null) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class DependenciesNestedImpl<N> extends MavenArtifactFluentImpl<CapabilityFluentImpl.DependenciesNested<N>> implements CapabilityFluentImpl.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(int index,MavenArtifact item) {
      this.index = index;
      this.builder = new MavenArtifactBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new MavenArtifactBuilder(this);
    }
    MavenArtifactBuilder builder;
    int index;
    public N and() {
      return (N) CapabilityFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  
}