package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CapabilityBuilder extends CapabilityFluentImpl<CapabilityBuilder> implements VisitableBuilder<Capability,CapabilityBuilder>{
  public CapabilityBuilder() {
    this(false);
  }
  public CapabilityBuilder(Boolean validationEnabled) {
    this(new Capability(), validationEnabled);
  }
  public CapabilityBuilder(CapabilityFluent<?> fluent) {
    this(fluent, false);
  }
  public CapabilityBuilder(CapabilityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Capability(), validationEnabled);
  }
  public CapabilityBuilder(CapabilityFluent<?> fluent,Capability instance) {
    this(fluent, instance, false);
  }
  public CapabilityBuilder(CapabilityFluent<?> fluent,Capability instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDependencies(instance.getDependencies());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CapabilityBuilder(Capability instance) {
    this(instance,false);
  }
  public CapabilityBuilder(Capability instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDependencies(instance.getDependencies());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  CapabilityFluent<?> fluent;
  Boolean validationEnabled;
  public Capability build() {
    Capability buildable = new Capability(fluent.getDependencies(),fluent.getMetadata());
    return buildable;
  }
  
}