package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelSchemeScopeBuilder extends CamelSchemeScopeFluentImpl<CamelSchemeScopeBuilder> implements VisitableBuilder<CamelSchemeScope,CamelSchemeScopeBuilder>{
  public CamelSchemeScopeBuilder() {
    this(false);
  }
  public CamelSchemeScopeBuilder(Boolean validationEnabled) {
    this(new CamelSchemeScope(), validationEnabled);
  }
  public CamelSchemeScopeBuilder(CamelSchemeScopeFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelSchemeScopeBuilder(CamelSchemeScopeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelSchemeScope(), validationEnabled);
  }
  public CamelSchemeScopeBuilder(CamelSchemeScopeFluent<?> fluent,CamelSchemeScope instance) {
    this(fluent, instance, false);
  }
  public CamelSchemeScopeBuilder(CamelSchemeScopeFluent<?> fluent,CamelSchemeScope instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDependencies(instance.getDependencies());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CamelSchemeScopeBuilder(CamelSchemeScope instance) {
    this(instance,false);
  }
  public CamelSchemeScopeBuilder(CamelSchemeScope instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDependencies(instance.getDependencies());
    }
    this.validationEnabled = validationEnabled; 
  }
  CamelSchemeScopeFluent<?> fluent;
  Boolean validationEnabled;
  public CamelSchemeScope build() {
    CamelSchemeScope buildable = new CamelSchemeScope(fluent.getDependencies());
    return buildable;
  }
  
}