package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelSchemeBuilder extends CamelSchemeFluentImpl<CamelSchemeBuilder> implements VisitableBuilder<CamelScheme,CamelSchemeBuilder>{
  public CamelSchemeBuilder() {
    this(false);
  }
  public CamelSchemeBuilder(Boolean validationEnabled) {
    this(new CamelScheme(), validationEnabled);
  }
  public CamelSchemeBuilder(CamelSchemeFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelScheme(), validationEnabled);
  }
  public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,CamelScheme instance) {
    this(fluent, instance, false);
  }
  public CamelSchemeBuilder(CamelSchemeFluent<?> fluent,CamelScheme instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConsumer(instance.getConsumer());
      fluent.withHttp(instance.getHttp());
      fluent.withId(instance.getId());
      fluent.withPassive(instance.getPassive());
      fluent.withProducer(instance.getProducer());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CamelSchemeBuilder(CamelScheme instance) {
    this(instance,false);
  }
  public CamelSchemeBuilder(CamelScheme instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConsumer(instance.getConsumer());
      this.withHttp(instance.getHttp());
      this.withId(instance.getId());
      this.withPassive(instance.getPassive());
      this.withProducer(instance.getProducer());
    }
    this.validationEnabled = validationEnabled; 
  }
  CamelSchemeFluent<?> fluent;
  Boolean validationEnabled;
  public CamelScheme build() {
    CamelScheme buildable = new CamelScheme(fluent.getConsumer(),fluent.getHttp(),fluent.getId(),fluent.getPassive(),fluent.getProducer());
    return buildable;
  }
  
}