package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CamelLoaderFluent<A extends CamelLoaderFluent<A>> extends Fluent<A>{
  public String getArtifactId();
  public A withArtifactId(String artifactId);
  public Boolean hasArtifactId();
  public A addToDependencies(int index,MavenArtifact item);
  public A setToDependencies(int index,MavenArtifact item);
  public A addToDependencies(io.fabric8.camelk.v1.MavenArtifact... items);
  public A addAllToDependencies(Collection<MavenArtifact> items);
  public A removeFromDependencies(io.fabric8.camelk.v1.MavenArtifact... items);
  public A removeAllFromDependencies(Collection<MavenArtifact> items);
  public A removeMatchingFromDependencies(Predicate<MavenArtifactBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MavenArtifact> getDependencies();
  public List<MavenArtifact> buildDependencies();
  public MavenArtifact buildDependency(int index);
  public MavenArtifact buildFirstDependency();
  public MavenArtifact buildLastDependency();
  public MavenArtifact buildMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
  public Boolean hasMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
  public A withDependencies(List<MavenArtifact> dependencies);
  public A withDependencies(io.fabric8.camelk.v1.MavenArtifact... dependencies);
  public Boolean hasDependencies();
  public A addNewDependency(String artifactId,String groupId,String version);
  public CamelLoaderFluent.DependenciesNested<A> addNewDependency();
  public CamelLoaderFluent.DependenciesNested<A> addNewDependencyLike(MavenArtifact item);
  public CamelLoaderFluent.DependenciesNested<A> setNewDependencyLike(int index,MavenArtifact item);
  public CamelLoaderFluent.DependenciesNested<A> editDependency(int index);
  public CamelLoaderFluent.DependenciesNested<A> editFirstDependency();
  public CamelLoaderFluent.DependenciesNested<A> editLastDependency();
  public CamelLoaderFluent.DependenciesNested<A> editMatchingDependency(Predicate<MavenArtifactBuilder> predicate);
  public String getGroupId();
  public A withGroupId(String groupId);
  public Boolean hasGroupId();
  public A addToLanguages(int index,String item);
  public A setToLanguages(int index,String item);
  public A addToLanguages(java.lang.String... items);
  public A addAllToLanguages(Collection<String> items);
  public A removeFromLanguages(java.lang.String... items);
  public A removeAllFromLanguages(Collection<String> items);
  public List<String> getLanguages();
  public String getLanguage(int index);
  public String getFirstLanguage();
  public String getLastLanguage();
  public String getMatchingLanguage(Predicate<String> predicate);
  public Boolean hasMatchingLanguage(Predicate<String> predicate);
  public A withLanguages(List<String> languages);
  public A withLanguages(java.lang.String... languages);
  public Boolean hasLanguages();
  public A addToMetadata(String key,String value);
  public A addToMetadata(Map<String,String> map);
  public A removeFromMetadata(String key);
  public A removeFromMetadata(Map<String,String> map);
  public Map<String,String> getMetadata();
  public <K,V>A withMetadata(Map<String,String> metadata);
  public Boolean hasMetadata();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public interface DependenciesNested<N> extends Nested<N>,MavenArtifactFluent<CamelLoaderFluent.DependenciesNested<N>>{
    public N and();
    public N endDependency();
    
  }
  
}