package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelCatalogSpecBuilder extends CamelCatalogSpecFluentImpl<CamelCatalogSpecBuilder> implements VisitableBuilder<CamelCatalogSpec,CamelCatalogSpecBuilder>{
  public CamelCatalogSpecBuilder() {
    this(false);
  }
  public CamelCatalogSpecBuilder(Boolean validationEnabled) {
    this(new CamelCatalogSpec(), validationEnabled);
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelCatalogSpec(), validationEnabled);
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,CamelCatalogSpec instance) {
    this(fluent, instance, false);
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpecFluent<?> fluent,CamelCatalogSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withArtifacts(instance.getArtifacts());
      fluent.withLoaders(instance.getLoaders());
      fluent.withRuntime(instance.getRuntime());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpec instance) {
    this(instance,false);
  }
  public CamelCatalogSpecBuilder(CamelCatalogSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withArtifacts(instance.getArtifacts());
      this.withLoaders(instance.getLoaders());
      this.withRuntime(instance.getRuntime());
    }
    this.validationEnabled = validationEnabled; 
  }
  CamelCatalogSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CamelCatalogSpec build() {
    CamelCatalogSpec buildable = new CamelCatalogSpec(fluent.getArtifacts(),fluent.getLoaders(),fluent.getRuntime());
    return buildable;
  }
  
}