package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelCatalogListBuilder extends CamelCatalogListFluentImpl<CamelCatalogListBuilder> implements VisitableBuilder<CamelCatalogList,CamelCatalogListBuilder>{
  public CamelCatalogListBuilder() {
    this(false);
  }
  public CamelCatalogListBuilder(Boolean validationEnabled) {
    this(new CamelCatalogList(), validationEnabled);
  }
  public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelCatalogList(), validationEnabled);
  }
  public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,CamelCatalogList instance) {
    this(fluent, instance, false);
  }
  public CamelCatalogListBuilder(CamelCatalogListFluent<?> fluent,CamelCatalogList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CamelCatalogListBuilder(CamelCatalogList instance) {
    this(instance,false);
  }
  public CamelCatalogListBuilder(CamelCatalogList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  CamelCatalogListFluent<?> fluent;
  Boolean validationEnabled;
  public CamelCatalogList build() {
    CamelCatalogList buildable = new CamelCatalogList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}