package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CamelCatalogBuilder extends CamelCatalogFluentImpl<CamelCatalogBuilder> implements VisitableBuilder<CamelCatalog,CamelCatalogBuilder>{
  public CamelCatalogBuilder() {
    this(false);
  }
  public CamelCatalogBuilder(Boolean validationEnabled) {
    this(new CamelCatalog(), validationEnabled);
  }
  public CamelCatalogBuilder(CamelCatalogFluent<?> fluent) {
    this(fluent, false);
  }
  public CamelCatalogBuilder(CamelCatalogFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CamelCatalog(), validationEnabled);
  }
  public CamelCatalogBuilder(CamelCatalogFluent<?> fluent,CamelCatalog instance) {
    this(fluent, instance, false);
  }
  public CamelCatalogBuilder(CamelCatalogFluent<?> fluent,CamelCatalog instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CamelCatalogBuilder(CamelCatalog instance) {
    this(instance,false);
  }
  public CamelCatalogBuilder(CamelCatalog instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  CamelCatalogFluent<?> fluent;
  Boolean validationEnabled;
  public CamelCatalog build() {
    CamelCatalog buildable = new CamelCatalog(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}