package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CamelArtifactFluentImpl<A extends CamelArtifactFluent<A>> extends BaseFluent<A> implements CamelArtifactFluent<A>{
  public CamelArtifactFluentImpl() {
  }
  public CamelArtifactFluentImpl(CamelArtifact instance) {
    if (instance != null) {
      this.withArtifactId(instance.getArtifactId());
      this.withDataformats(instance.getDataformats());
      this.withDependencies(instance.getDependencies());
      this.withExclusions(instance.getExclusions());
      this.withGroupId(instance.getGroupId());
      this.withJavaTypes(instance.getJavaTypes());
      this.withLanguages(instance.getLanguages());
      this.withSchemes(instance.getSchemes());
      this.withVersion(instance.getVersion());
    }
  }
  private String artifactId;
  private List<String> dataformats = new ArrayList<String>();
  private ArrayList<CamelArtifactDependencyBuilder> dependencies = new ArrayList<CamelArtifactDependencyBuilder>();
  private ArrayList<CamelArtifactExclusionBuilder> exclusions = new ArrayList<CamelArtifactExclusionBuilder>();
  private String groupId;
  private List<String> javaTypes = new ArrayList<String>();
  private List<String> languages = new ArrayList<String>();
  private ArrayList<CamelSchemeBuilder> schemes = new ArrayList<CamelSchemeBuilder>();
  private String version;
  public String getArtifactId() {
    return this.artifactId;
  }
  public A withArtifactId(String artifactId) {
    this.artifactId=artifactId; return (A) this;
  }
  public Boolean hasArtifactId() {
    return this.artifactId != null;
  }
  public A addToDataformats(int index,String item) {
    if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
    this.dataformats.add(index, item);
    return (A)this;
  }
  public A setToDataformats(int index,String item) {
    if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
    this.dataformats.set(index, item); return (A)this;
  }
  public A addToDataformats(java.lang.String... items) {
    if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
    for (String item : items) {this.dataformats.add(item);} return (A)this;
  }
  public A addAllToDataformats(Collection<String> items) {
    if (this.dataformats == null) {this.dataformats = new ArrayList<String>();}
    for (String item : items) {this.dataformats.add(item);} return (A)this;
  }
  public A removeFromDataformats(java.lang.String... items) {
    for (String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
  }
  public A removeAllFromDataformats(Collection<String> items) {
    for (String item : items) {if (this.dataformats!= null){ this.dataformats.remove(item);}} return (A)this;
  }
  public List<String> getDataformats() {
    return this.dataformats;
  }
  public String getDataformat(int index) {
    return this.dataformats.get(index);
  }
  public String getFirstDataformat() {
    return this.dataformats.get(0);
  }
  public String getLastDataformat() {
    return this.dataformats.get(dataformats.size() - 1);
  }
  public String getMatchingDataformat(Predicate<String> predicate) {
    for (String item: dataformats) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDataformat(Predicate<String> predicate) {
    for (String item: dataformats) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDataformats(List<String> dataformats) {
    if (dataformats != null) {this.dataformats = new ArrayList(); for (String item : dataformats){this.addToDataformats(item);}} else { this.dataformats = null;} return (A) this;
  }
  public A withDataformats(java.lang.String... dataformats) {
    if (this.dataformats != null) {this.dataformats.clear(); _visitables.remove("dataformats"); }
    if (dataformats != null) {for (String item :dataformats){ this.addToDataformats(item);}} return (A) this;
  }
  public Boolean hasDataformats() {
    return dataformats != null && !dataformats.isEmpty();
  }
  public A addToDependencies(int index,CamelArtifactDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
    CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  public A setToDependencies(int index,CamelArtifactDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
    CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  public A addToDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
    for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<CamelArtifactDependency> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<CamelArtifactDependencyBuilder>();}
    for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items) {
    for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<CamelArtifactDependency> items) {
    for (CamelArtifactDependency item : items) {CamelArtifactDependencyBuilder builder = new CamelArtifactDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<CamelArtifactDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      CamelArtifactDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelArtifactDependency> getDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public List<CamelArtifactDependency> buildDependencies() {
    return dependencies != null ? build(dependencies) : null;
  }
  public CamelArtifactDependency buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  public CamelArtifactDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public CamelArtifactDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
    for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
    for (CamelArtifactDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<CamelArtifactDependency> dependencies) {
    if (this.dependencies != null) { _visitables.get("dependencies").clear();}
    if (dependencies != null) {this.dependencies = new ArrayList(); for (CamelArtifactDependency item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (CamelArtifactDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> addNewDependency() {
    return new CamelArtifactFluentImpl.DependenciesNestedImpl();
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item) {
    return new CamelArtifactFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item) {
    return new CamelArtifactFluentImpl.DependenciesNestedImpl(index, item);
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public CamelArtifactFluentImpl.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A addToExclusions(int index,CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
    if (index < 0 || index >= exclusions.size()) { _visitables.get("exclusions").add(builder); exclusions.add(builder); } else { _visitables.get("exclusions").add(index, builder); exclusions.add(index, builder);}
    return (A)this;
  }
  public A setToExclusions(int index,CamelArtifactExclusion item) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);
    if (index < 0 || index >= exclusions.size()) { _visitables.get("exclusions").add(builder); exclusions.add(builder); } else { _visitables.get("exclusions").set(index, builder); exclusions.set(index, builder);}
    return (A)this;
  }
  public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A addAllToExclusions(Collection<CamelArtifactExclusion> items) {
    if (this.exclusions == null) {this.exclusions = new ArrayList<CamelArtifactExclusionBuilder>();}
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").add(builder);this.exclusions.add(builder);} return (A)this;
  }
  public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items) {
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items) {
    for (CamelArtifactExclusion item : items) {CamelArtifactExclusionBuilder builder = new CamelArtifactExclusionBuilder(item);_visitables.get("exclusions").remove(builder);if (this.exclusions != null) {this.exclusions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate) {
    if (exclusions == null) return (A) this;
    final Iterator<CamelArtifactExclusionBuilder> each = exclusions.iterator();
    final List visitables = _visitables.get("exclusions");
    while (each.hasNext()) {
      CamelArtifactExclusionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExclusions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelArtifactExclusion> getExclusions() {
    return exclusions != null ? build(exclusions) : null;
  }
  public List<CamelArtifactExclusion> buildExclusions() {
    return exclusions != null ? build(exclusions) : null;
  }
  public CamelArtifactExclusion buildExclusion(int index) {
    return this.exclusions.get(index).build();
  }
  public CamelArtifactExclusion buildFirstExclusion() {
    return this.exclusions.get(0).build();
  }
  public CamelArtifactExclusion buildLastExclusion() {
    return this.exclusions.get(exclusions.size() - 1).build();
  }
  public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    for (CamelArtifactExclusionBuilder item: exclusions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExclusions(List<CamelArtifactExclusion> exclusions) {
    if (this.exclusions != null) { _visitables.get("exclusions").clear();}
    if (exclusions != null) {this.exclusions = new ArrayList(); for (CamelArtifactExclusion item : exclusions){this.addToExclusions(item);}} else { this.exclusions = null;} return (A) this;
  }
  public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions) {
    if (this.exclusions != null) {this.exclusions.clear(); _visitables.remove("exclusions"); }
    if (exclusions != null) {for (CamelArtifactExclusion item :exclusions){ this.addToExclusions(item);}} return (A) this;
  }
  public Boolean hasExclusions() {
    return exclusions != null && !exclusions.isEmpty();
  }
  public A addNewExclusion(String artifactId,String groupId) {
    return (A)addToExclusions(new CamelArtifactExclusion(artifactId, groupId));
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> addNewExclusion() {
    return new CamelArtifactFluentImpl.ExclusionsNestedImpl();
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item) {
    return new CamelArtifactFluentImpl.ExclusionsNestedImpl(-1, item);
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> setNewExclusionLike(int index,CamelArtifactExclusion item) {
    return new CamelArtifactFluentImpl.ExclusionsNestedImpl(index, item);
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> editExclusion(int index) {
    if (exclusions.size() <= index) throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> editFirstExclusion() {
    if (exclusions.size() == 0) throw new RuntimeException("Can't edit first exclusions. The list is empty.");
    return setNewExclusionLike(0, buildExclusion(0));
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> editLastExclusion() {
    int index = exclusions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last exclusions. The list is empty.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public CamelArtifactFluentImpl.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<exclusions.size();i++) { 
    if (predicate.test(exclusions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching exclusions. No match found.");
    return setNewExclusionLike(index, buildExclusion(index));
  }
  public String getGroupId() {
    return this.groupId;
  }
  public A withGroupId(String groupId) {
    this.groupId=groupId; return (A) this;
  }
  public Boolean hasGroupId() {
    return this.groupId != null;
  }
  public A addToJavaTypes(int index,String item) {
    if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
    this.javaTypes.add(index, item);
    return (A)this;
  }
  public A setToJavaTypes(int index,String item) {
    if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
    this.javaTypes.set(index, item); return (A)this;
  }
  public A addToJavaTypes(java.lang.String... items) {
    if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
    for (String item : items) {this.javaTypes.add(item);} return (A)this;
  }
  public A addAllToJavaTypes(Collection<String> items) {
    if (this.javaTypes == null) {this.javaTypes = new ArrayList<String>();}
    for (String item : items) {this.javaTypes.add(item);} return (A)this;
  }
  public A removeFromJavaTypes(java.lang.String... items) {
    for (String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
  }
  public A removeAllFromJavaTypes(Collection<String> items) {
    for (String item : items) {if (this.javaTypes!= null){ this.javaTypes.remove(item);}} return (A)this;
  }
  public List<String> getJavaTypes() {
    return this.javaTypes;
  }
  public String getJavaType(int index) {
    return this.javaTypes.get(index);
  }
  public String getFirstJavaType() {
    return this.javaTypes.get(0);
  }
  public String getLastJavaType() {
    return this.javaTypes.get(javaTypes.size() - 1);
  }
  public String getMatchingJavaType(Predicate<String> predicate) {
    for (String item: javaTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingJavaType(Predicate<String> predicate) {
    for (String item: javaTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withJavaTypes(List<String> javaTypes) {
    if (javaTypes != null) {this.javaTypes = new ArrayList(); for (String item : javaTypes){this.addToJavaTypes(item);}} else { this.javaTypes = null;} return (A) this;
  }
  public A withJavaTypes(java.lang.String... javaTypes) {
    if (this.javaTypes != null) {this.javaTypes.clear(); _visitables.remove("javaTypes"); }
    if (javaTypes != null) {for (String item :javaTypes){ this.addToJavaTypes(item);}} return (A) this;
  }
  public Boolean hasJavaTypes() {
    return javaTypes != null && !javaTypes.isEmpty();
  }
  public A addToLanguages(int index,String item) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    this.languages.add(index, item);
    return (A)this;
  }
  public A setToLanguages(int index,String item) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    this.languages.set(index, item); return (A)this;
  }
  public A addToLanguages(java.lang.String... items) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    for (String item : items) {this.languages.add(item);} return (A)this;
  }
  public A addAllToLanguages(Collection<String> items) {
    if (this.languages == null) {this.languages = new ArrayList<String>();}
    for (String item : items) {this.languages.add(item);} return (A)this;
  }
  public A removeFromLanguages(java.lang.String... items) {
    for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public A removeAllFromLanguages(Collection<String> items) {
    for (String item : items) {if (this.languages!= null){ this.languages.remove(item);}} return (A)this;
  }
  public List<String> getLanguages() {
    return this.languages;
  }
  public String getLanguage(int index) {
    return this.languages.get(index);
  }
  public String getFirstLanguage() {
    return this.languages.get(0);
  }
  public String getLastLanguage() {
    return this.languages.get(languages.size() - 1);
  }
  public String getMatchingLanguage(Predicate<String> predicate) {
    for (String item: languages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingLanguage(Predicate<String> predicate) {
    for (String item: languages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLanguages(List<String> languages) {
    if (languages != null) {this.languages = new ArrayList(); for (String item : languages){this.addToLanguages(item);}} else { this.languages = null;} return (A) this;
  }
  public A withLanguages(java.lang.String... languages) {
    if (this.languages != null) {this.languages.clear(); _visitables.remove("languages"); }
    if (languages != null) {for (String item :languages){ this.addToLanguages(item);}} return (A) this;
  }
  public Boolean hasLanguages() {
    return languages != null && !languages.isEmpty();
  }
  public A addToSchemes(int index,CamelScheme item) {
    if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
    CamelSchemeBuilder builder = new CamelSchemeBuilder(item);
    if (index < 0 || index >= schemes.size()) { _visitables.get("schemes").add(builder); schemes.add(builder); } else { _visitables.get("schemes").add(index, builder); schemes.add(index, builder);}
    return (A)this;
  }
  public A setToSchemes(int index,CamelScheme item) {
    if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
    CamelSchemeBuilder builder = new CamelSchemeBuilder(item);
    if (index < 0 || index >= schemes.size()) { _visitables.get("schemes").add(builder); schemes.add(builder); } else { _visitables.get("schemes").set(index, builder); schemes.set(index, builder);}
    return (A)this;
  }
  public A addToSchemes(io.fabric8.camelk.v1.CamelScheme... items) {
    if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
    for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
  }
  public A addAllToSchemes(Collection<CamelScheme> items) {
    if (this.schemes == null) {this.schemes = new ArrayList<CamelSchemeBuilder>();}
    for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").add(builder);this.schemes.add(builder);} return (A)this;
  }
  public A removeFromSchemes(io.fabric8.camelk.v1.CamelScheme... items) {
    for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
  }
  public A removeAllFromSchemes(Collection<CamelScheme> items) {
    for (CamelScheme item : items) {CamelSchemeBuilder builder = new CamelSchemeBuilder(item);_visitables.get("schemes").remove(builder);if (this.schemes != null) {this.schemes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSchemes(Predicate<CamelSchemeBuilder> predicate) {
    if (schemes == null) return (A) this;
    final Iterator<CamelSchemeBuilder> each = schemes.iterator();
    final List visitables = _visitables.get("schemes");
    while (each.hasNext()) {
      CamelSchemeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSchemes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelScheme> getSchemes() {
    return schemes != null ? build(schemes) : null;
  }
  public List<CamelScheme> buildSchemes() {
    return schemes != null ? build(schemes) : null;
  }
  public CamelScheme buildScheme(int index) {
    return this.schemes.get(index).build();
  }
  public CamelScheme buildFirstScheme() {
    return this.schemes.get(0).build();
  }
  public CamelScheme buildLastScheme() {
    return this.schemes.get(schemes.size() - 1).build();
  }
  public CamelScheme buildMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
    for (CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
    for (CamelSchemeBuilder item: schemes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSchemes(List<CamelScheme> schemes) {
    if (this.schemes != null) { _visitables.get("schemes").clear();}
    if (schemes != null) {this.schemes = new ArrayList(); for (CamelScheme item : schemes){this.addToSchemes(item);}} else { this.schemes = null;} return (A) this;
  }
  public A withSchemes(io.fabric8.camelk.v1.CamelScheme... schemes) {
    if (this.schemes != null) {this.schemes.clear(); _visitables.remove("schemes"); }
    if (schemes != null) {for (CamelScheme item :schemes){ this.addToSchemes(item);}} return (A) this;
  }
  public Boolean hasSchemes() {
    return schemes != null && !schemes.isEmpty();
  }
  public CamelArtifactFluentImpl.SchemesNested<A> addNewScheme() {
    return new CamelArtifactFluentImpl.SchemesNestedImpl();
  }
  public CamelArtifactFluentImpl.SchemesNested<A> addNewSchemeLike(CamelScheme item) {
    return new CamelArtifactFluentImpl.SchemesNestedImpl(-1, item);
  }
  public CamelArtifactFluentImpl.SchemesNested<A> setNewSchemeLike(int index,CamelScheme item) {
    return new CamelArtifactFluentImpl.SchemesNestedImpl(index, item);
  }
  public CamelArtifactFluentImpl.SchemesNested<A> editScheme(int index) {
    if (schemes.size() <= index) throw new RuntimeException("Can't edit schemes. Index exceeds size.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public CamelArtifactFluentImpl.SchemesNested<A> editFirstScheme() {
    if (schemes.size() == 0) throw new RuntimeException("Can't edit first schemes. The list is empty.");
    return setNewSchemeLike(0, buildScheme(0));
  }
  public CamelArtifactFluentImpl.SchemesNested<A> editLastScheme() {
    int index = schemes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last schemes. The list is empty.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public CamelArtifactFluentImpl.SchemesNested<A> editMatchingScheme(Predicate<CamelSchemeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<schemes.size();i++) { 
    if (predicate.test(schemes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching schemes. No match found.");
    return setNewSchemeLike(index, buildScheme(index));
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CamelArtifactFluentImpl that = (CamelArtifactFluentImpl) o;
    if (!java.util.Objects.equals(artifactId, that.artifactId)) return false;

    if (!java.util.Objects.equals(dataformats, that.dataformats)) return false;

    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(exclusions, that.exclusions)) return false;

    if (!java.util.Objects.equals(groupId, that.groupId)) return false;

    if (!java.util.Objects.equals(javaTypes, that.javaTypes)) return false;

    if (!java.util.Objects.equals(languages, that.languages)) return false;

    if (!java.util.Objects.equals(schemes, that.schemes)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(artifactId,  dataformats,  dependencies,  exclusions,  groupId,  javaTypes,  languages,  schemes,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (artifactId != null) { sb.append("artifactId:"); sb.append(artifactId + ","); }
    if (dataformats != null && !dataformats.isEmpty()) { sb.append("dataformats:"); sb.append(dataformats + ","); }
    if (dependencies != null) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (exclusions != null) { sb.append("exclusions:"); sb.append(exclusions + ","); }
    if (groupId != null) { sb.append("groupId:"); sb.append(groupId + ","); }
    if (javaTypes != null && !javaTypes.isEmpty()) { sb.append("javaTypes:"); sb.append(javaTypes + ","); }
    if (languages != null && !languages.isEmpty()) { sb.append("languages:"); sb.append(languages + ","); }
    if (schemes != null) { sb.append("schemes:"); sb.append(schemes + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class DependenciesNestedImpl<N> extends CamelArtifactDependencyFluentImpl<CamelArtifactFluentImpl.DependenciesNested<N>> implements CamelArtifactFluentImpl.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(int index,CamelArtifactDependency item) {
      this.index = index;
      this.builder = new CamelArtifactDependencyBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new CamelArtifactDependencyBuilder(this);
    }
    CamelArtifactDependencyBuilder builder;
    int index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  class ExclusionsNestedImpl<N> extends CamelArtifactExclusionFluentImpl<CamelArtifactFluentImpl.ExclusionsNested<N>> implements CamelArtifactFluentImpl.ExclusionsNested<N>,Nested<N>{
    ExclusionsNestedImpl(int index,CamelArtifactExclusion item) {
      this.index = index;
      this.builder = new CamelArtifactExclusionBuilder(this, item);
    }
    ExclusionsNestedImpl() {
      this.index = -1;
      this.builder = new CamelArtifactExclusionBuilder(this);
    }
    CamelArtifactExclusionBuilder builder;
    int index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToExclusions(index,builder.build());
    }
    public N endExclusion() {
      return and();
    }
    
  }
  class SchemesNestedImpl<N> extends CamelSchemeFluentImpl<CamelArtifactFluentImpl.SchemesNested<N>> implements CamelArtifactFluentImpl.SchemesNested<N>,Nested<N>{
    SchemesNestedImpl(int index,CamelScheme item) {
      this.index = index;
      this.builder = new CamelSchemeBuilder(this, item);
    }
    SchemesNestedImpl() {
      this.index = -1;
      this.builder = new CamelSchemeBuilder(this);
    }
    CamelSchemeBuilder builder;
    int index;
    public N and() {
      return (N) CamelArtifactFluentImpl.this.setToSchemes(index,builder.build());
    }
    public N endScheme() {
      return and();
    }
    
  }
  
}