package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;

 /**
  * Generated
  */
public interface CamelArtifactFluent<A extends CamelArtifactFluent<A>> extends Fluent<A>{
  public String getArtifactId();
  public A withArtifactId(String artifactId);
  public Boolean hasArtifactId();
  public A addToDataformats(int index,String item);
  public A setToDataformats(int index,String item);
  public A addToDataformats(java.lang.String... items);
  public A addAllToDataformats(Collection<String> items);
  public A removeFromDataformats(java.lang.String... items);
  public A removeAllFromDataformats(Collection<String> items);
  public List<String> getDataformats();
  public String getDataformat(int index);
  public String getFirstDataformat();
  public String getLastDataformat();
  public String getMatchingDataformat(Predicate<String> predicate);
  public Boolean hasMatchingDataformat(Predicate<String> predicate);
  public A withDataformats(List<String> dataformats);
  public A withDataformats(java.lang.String... dataformats);
  public Boolean hasDataformats();
  public A addToDependencies(int index,CamelArtifactDependency item);
  public A setToDependencies(int index,CamelArtifactDependency item);
  public A addToDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items);
  public A addAllToDependencies(Collection<CamelArtifactDependency> items);
  public A removeFromDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... items);
  public A removeAllFromDependencies(Collection<CamelArtifactDependency> items);
  public A removeMatchingFromDependencies(Predicate<CamelArtifactDependencyBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelArtifactDependency> getDependencies();
  public List<CamelArtifactDependency> buildDependencies();
  public CamelArtifactDependency buildDependency(int index);
  public CamelArtifactDependency buildFirstDependency();
  public CamelArtifactDependency buildLastDependency();
  public CamelArtifactDependency buildMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
  public Boolean hasMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
  public A withDependencies(List<CamelArtifactDependency> dependencies);
  public A withDependencies(io.fabric8.camelk.v1.CamelArtifactDependency... dependencies);
  public Boolean hasDependencies();
  public CamelArtifactFluent.DependenciesNested<A> addNewDependency();
  public CamelArtifactFluent.DependenciesNested<A> addNewDependencyLike(CamelArtifactDependency item);
  public CamelArtifactFluent.DependenciesNested<A> setNewDependencyLike(int index,CamelArtifactDependency item);
  public CamelArtifactFluent.DependenciesNested<A> editDependency(int index);
  public CamelArtifactFluent.DependenciesNested<A> editFirstDependency();
  public CamelArtifactFluent.DependenciesNested<A> editLastDependency();
  public CamelArtifactFluent.DependenciesNested<A> editMatchingDependency(Predicate<CamelArtifactDependencyBuilder> predicate);
  public A addToExclusions(int index,CamelArtifactExclusion item);
  public A setToExclusions(int index,CamelArtifactExclusion item);
  public A addToExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items);
  public A addAllToExclusions(Collection<CamelArtifactExclusion> items);
  public A removeFromExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... items);
  public A removeAllFromExclusions(Collection<CamelArtifactExclusion> items);
  public A removeMatchingFromExclusions(Predicate<CamelArtifactExclusionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExclusions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelArtifactExclusion> getExclusions();
  public List<CamelArtifactExclusion> buildExclusions();
  public CamelArtifactExclusion buildExclusion(int index);
  public CamelArtifactExclusion buildFirstExclusion();
  public CamelArtifactExclusion buildLastExclusion();
  public CamelArtifactExclusion buildMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
  public Boolean hasMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
  public A withExclusions(List<CamelArtifactExclusion> exclusions);
  public A withExclusions(io.fabric8.camelk.v1.CamelArtifactExclusion... exclusions);
  public Boolean hasExclusions();
  public A addNewExclusion(String artifactId,String groupId);
  public CamelArtifactFluent.ExclusionsNested<A> addNewExclusion();
  public CamelArtifactFluent.ExclusionsNested<A> addNewExclusionLike(CamelArtifactExclusion item);
  public CamelArtifactFluent.ExclusionsNested<A> setNewExclusionLike(int index,CamelArtifactExclusion item);
  public CamelArtifactFluent.ExclusionsNested<A> editExclusion(int index);
  public CamelArtifactFluent.ExclusionsNested<A> editFirstExclusion();
  public CamelArtifactFluent.ExclusionsNested<A> editLastExclusion();
  public CamelArtifactFluent.ExclusionsNested<A> editMatchingExclusion(Predicate<CamelArtifactExclusionBuilder> predicate);
  public String getGroupId();
  public A withGroupId(String groupId);
  public Boolean hasGroupId();
  public A addToJavaTypes(int index,String item);
  public A setToJavaTypes(int index,String item);
  public A addToJavaTypes(java.lang.String... items);
  public A addAllToJavaTypes(Collection<String> items);
  public A removeFromJavaTypes(java.lang.String... items);
  public A removeAllFromJavaTypes(Collection<String> items);
  public List<String> getJavaTypes();
  public String getJavaType(int index);
  public String getFirstJavaType();
  public String getLastJavaType();
  public String getMatchingJavaType(Predicate<String> predicate);
  public Boolean hasMatchingJavaType(Predicate<String> predicate);
  public A withJavaTypes(List<String> javaTypes);
  public A withJavaTypes(java.lang.String... javaTypes);
  public Boolean hasJavaTypes();
  public A addToLanguages(int index,String item);
  public A setToLanguages(int index,String item);
  public A addToLanguages(java.lang.String... items);
  public A addAllToLanguages(Collection<String> items);
  public A removeFromLanguages(java.lang.String... items);
  public A removeAllFromLanguages(Collection<String> items);
  public List<String> getLanguages();
  public String getLanguage(int index);
  public String getFirstLanguage();
  public String getLastLanguage();
  public String getMatchingLanguage(Predicate<String> predicate);
  public Boolean hasMatchingLanguage(Predicate<String> predicate);
  public A withLanguages(List<String> languages);
  public A withLanguages(java.lang.String... languages);
  public Boolean hasLanguages();
  public A addToSchemes(int index,CamelScheme item);
  public A setToSchemes(int index,CamelScheme item);
  public A addToSchemes(io.fabric8.camelk.v1.CamelScheme... items);
  public A addAllToSchemes(Collection<CamelScheme> items);
  public A removeFromSchemes(io.fabric8.camelk.v1.CamelScheme... items);
  public A removeAllFromSchemes(Collection<CamelScheme> items);
  public A removeMatchingFromSchemes(Predicate<CamelSchemeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSchemes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CamelScheme> getSchemes();
  public List<CamelScheme> buildSchemes();
  public CamelScheme buildScheme(int index);
  public CamelScheme buildFirstScheme();
  public CamelScheme buildLastScheme();
  public CamelScheme buildMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
  public Boolean hasMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
  public A withSchemes(List<CamelScheme> schemes);
  public A withSchemes(io.fabric8.camelk.v1.CamelScheme... schemes);
  public Boolean hasSchemes();
  public CamelArtifactFluent.SchemesNested<A> addNewScheme();
  public CamelArtifactFluent.SchemesNested<A> addNewSchemeLike(CamelScheme item);
  public CamelArtifactFluent.SchemesNested<A> setNewSchemeLike(int index,CamelScheme item);
  public CamelArtifactFluent.SchemesNested<A> editScheme(int index);
  public CamelArtifactFluent.SchemesNested<A> editFirstScheme();
  public CamelArtifactFluent.SchemesNested<A> editLastScheme();
  public CamelArtifactFluent.SchemesNested<A> editMatchingScheme(Predicate<CamelSchemeBuilder> predicate);
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public interface DependenciesNested<N> extends Nested<N>,CamelArtifactDependencyFluent<CamelArtifactFluent.DependenciesNested<N>>{
    public N and();
    public N endDependency();
    
  }
  public interface ExclusionsNested<N> extends Nested<N>,CamelArtifactExclusionFluent<CamelArtifactFluent.ExclusionsNested<N>>{
    public N and();
    public N endExclusion();
    
  }
  public interface SchemesNested<N> extends Nested<N>,CamelSchemeFluent<CamelArtifactFluent.SchemesNested<N>>{
    public N and();
    public N endScheme();
    
  }
  
}