package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;

 /**
  * Generated
  */
public interface BuilderTaskFluent<A extends BuilderTaskFluent<A>> extends Fluent<A>{
  public String getBaseImage();
  public A withBaseImage(String baseImage);
  public Boolean hasBaseImage();
  public String getBuildDir();
  public A withBuildDir(String buildDir);
  public Boolean hasBuildDir();
  public A addToDependencies(int index,String item);
  public A setToDependencies(int index,String item);
  public A addToDependencies(java.lang.String... items);
  public A addAllToDependencies(Collection<String> items);
  public A removeFromDependencies(java.lang.String... items);
  public A removeAllFromDependencies(Collection<String> items);
  public List<String> getDependencies();
  public String getDependency(int index);
  public String getFirstDependency();
  public String getLastDependency();
  public String getMatchingDependency(Predicate<String> predicate);
  public Boolean hasMatchingDependency(Predicate<String> predicate);
  public A withDependencies(List<String> dependencies);
  public A withDependencies(java.lang.String... dependencies);
  public Boolean hasDependencies();
  
  /**
   * This method has been deprecated, please use method buildMaven instead.
   * @return The buildable object.
   */
  @Deprecated
  public MavenBuildSpec getMaven();
  public MavenBuildSpec buildMaven();
  public A withMaven(MavenBuildSpec maven);
  public Boolean hasMaven();
  public BuilderTaskFluent.MavenNested<A> withNewMaven();
  public BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenBuildSpec item);
  public BuilderTaskFluent.MavenNested<A> editMaven();
  public BuilderTaskFluent.MavenNested<A> editOrNewMaven();
  public BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenBuildSpec item);
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public A addToResources(int index,ResourceSpec item);
  public A setToResources(int index,ResourceSpec item);
  public A addToResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A addAllToResources(Collection<ResourceSpec> items);
  public A removeFromResources(io.fabric8.camelk.v1.ResourceSpec... items);
  public A removeAllFromResources(Collection<ResourceSpec> items);
  public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceSpec> getResources();
  public List<ResourceSpec> buildResources();
  public ResourceSpec buildResource(int index);
  public ResourceSpec buildFirstResource();
  public ResourceSpec buildLastResource();
  public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  public A withResources(List<ResourceSpec> resources);
  public A withResources(io.fabric8.camelk.v1.ResourceSpec... resources);
  public Boolean hasResources();
  public BuilderTaskFluent.ResourcesNested<A> addNewResource();
  public BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item);
  public BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item);
  public BuilderTaskFluent.ResourcesNested<A> editResource(int index);
  public BuilderTaskFluent.ResourcesNested<A> editFirstResource();
  public BuilderTaskFluent.ResourcesNested<A> editLastResource();
  public BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRuntime instead.
   * @return The buildable object.
   */
  @Deprecated
  public RuntimeSpec getRuntime();
  public RuntimeSpec buildRuntime();
  public A withRuntime(RuntimeSpec runtime);
  public Boolean hasRuntime();
  public BuilderTaskFluent.RuntimeNested<A> withNewRuntime();
  public BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item);
  public BuilderTaskFluent.RuntimeNested<A> editRuntime();
  public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime();
  public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item);
  public A addToSources(int index,SourceSpec item);
  public A setToSources(int index,SourceSpec item);
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A addAllToSources(Collection<SourceSpec> items);
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items);
  public A removeAllFromSources(Collection<SourceSpec> items);
  public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<SourceSpec> getSources();
  public List<SourceSpec> buildSources();
  public SourceSpec buildSource(int index);
  public SourceSpec buildFirstSource();
  public SourceSpec buildLastSource();
  public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate);
  public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate);
  public A withSources(List<SourceSpec> sources);
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources);
  public Boolean hasSources();
  public BuilderTaskFluent.SourcesNested<A> addNewSource();
  public BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item);
  public BuilderTaskFluent.SourcesNested<A> setNewSourceLike(int index,SourceSpec item);
  public BuilderTaskFluent.SourcesNested<A> editSource(int index);
  public BuilderTaskFluent.SourcesNested<A> editFirstSource();
  public BuilderTaskFluent.SourcesNested<A> editLastSource();
  public BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate);
  public A addToSteps(int index,String item);
  public A setToSteps(int index,String item);
  public A addToSteps(java.lang.String... items);
  public A addAllToSteps(Collection<String> items);
  public A removeFromSteps(java.lang.String... items);
  public A removeAllFromSteps(Collection<String> items);
  public List<String> getSteps();
  public String getStep(int index);
  public String getFirstStep();
  public String getLastStep();
  public String getMatchingStep(Predicate<String> predicate);
  public Boolean hasMatchingStep(Predicate<String> predicate);
  public A withSteps(List<String> steps);
  public A withSteps(java.lang.String... steps);
  public Boolean hasSteps();
  public interface MavenNested<N> extends Nested<N>,MavenBuildSpecFluent<BuilderTaskFluent.MavenNested<N>>{
    public N and();
    public N endMaven();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceSpecFluent<BuilderTaskFluent.ResourcesNested<N>>{
    public N and();
    public N endResource();
    
  }
  public interface RuntimeNested<N> extends Nested<N>,RuntimeSpecFluent<BuilderTaskFluent.RuntimeNested<N>>{
    public N and();
    public N endRuntime();
    
  }
  public interface SourcesNested<N> extends Nested<N>,SourceSpecFluent<BuilderTaskFluent.SourcesNested<N>>{
    public N and();
    public N endSource();
    
  }
  
}