package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;

 /**
  * Generated
  */
public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends Fluent<A>{
  public A addToArtifacts(int index,Artifact item);
  public A setToArtifacts(int index,Artifact item);
  public A addToArtifacts(io.fabric8.camelk.v1.Artifact... items);
  public A addAllToArtifacts(Collection<Artifact> items);
  public A removeFromArtifacts(io.fabric8.camelk.v1.Artifact... items);
  public A removeAllFromArtifacts(Collection<Artifact> items);
  public A removeMatchingFromArtifacts(Predicate<ArtifactBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildArtifacts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Artifact> getArtifacts();
  public List<Artifact> buildArtifacts();
  public Artifact buildArtifact(int index);
  public Artifact buildFirstArtifact();
  public Artifact buildLastArtifact();
  public Artifact buildMatchingArtifact(Predicate<ArtifactBuilder> predicate);
  public Boolean hasMatchingArtifact(Predicate<ArtifactBuilder> predicate);
  public A withArtifacts(List<Artifact> artifacts);
  public A withArtifacts(io.fabric8.camelk.v1.Artifact... artifacts);
  public Boolean hasArtifacts();
  public A addNewArtifact(String checksum,String id,String location,String target);
  public BuildStatusFluent.ArtifactsNested<A> addNewArtifact();
  public BuildStatusFluent.ArtifactsNested<A> addNewArtifactLike(Artifact item);
  public BuildStatusFluent.ArtifactsNested<A> setNewArtifactLike(int index,Artifact item);
  public BuildStatusFluent.ArtifactsNested<A> editArtifact(int index);
  public BuildStatusFluent.ArtifactsNested<A> editFirstArtifact();
  public BuildStatusFluent.ArtifactsNested<A> editLastArtifact();
  public BuildStatusFluent.ArtifactsNested<A> editMatchingArtifact(Predicate<ArtifactBuilder> predicate);
  public String getBaseImage();
  public A withBaseImage(String baseImage);
  public Boolean hasBaseImage();
  public A addToConditions(int index,BuildCondition item);
  public A setToConditions(int index,BuildCondition item);
  public A addToConditions(io.fabric8.camelk.v1.BuildCondition... items);
  public A addAllToConditions(Collection<BuildCondition> items);
  public A removeFromConditions(io.fabric8.camelk.v1.BuildCondition... items);
  public A removeAllFromConditions(Collection<BuildCondition> items);
  public A removeMatchingFromConditions(Predicate<BuildConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BuildCondition> getConditions();
  public List<BuildCondition> buildConditions();
  public BuildCondition buildCondition(int index);
  public BuildCondition buildFirstCondition();
  public BuildCondition buildLastCondition();
  public BuildCondition buildMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  public A withConditions(List<BuildCondition> conditions);
  public A withConditions(io.fabric8.camelk.v1.BuildCondition... conditions);
  public Boolean hasConditions();
  public BuildStatusFluent.ConditionsNested<A> addNewCondition();
  public BuildStatusFluent.ConditionsNested<A> addNewConditionLike(BuildCondition item);
  public BuildStatusFluent.ConditionsNested<A> setNewConditionLike(int index,BuildCondition item);
  public BuildStatusFluent.ConditionsNested<A> editCondition(int index);
  public BuildStatusFluent.ConditionsNested<A> editFirstCondition();
  public BuildStatusFluent.ConditionsNested<A> editLastCondition();
  public BuildStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<BuildConditionBuilder> predicate);
  public String getDigest();
  public A withDigest(String digest);
  public Boolean hasDigest();
  public String getDuration();
  public A withDuration(String duration);
  public Boolean hasDuration();
  public String getError();
  public A withError(String error);
  public Boolean hasError();
  
  /**
   * This method has been deprecated, please use method buildFailure instead.
   * @return The buildable object.
   */
  @Deprecated
  public Failure getFailure();
  public Failure buildFailure();
  public A withFailure(Failure failure);
  public Boolean hasFailure();
  public BuildStatusFluent.FailureNested<A> withNewFailure();
  public BuildStatusFluent.FailureNested<A> withNewFailureLike(Failure item);
  public BuildStatusFluent.FailureNested<A> editFailure();
  public BuildStatusFluent.FailureNested<A> editOrNewFailure();
  public BuildStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item);
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public String getStartedAt();
  public A withStartedAt(String startedAt);
  public Boolean hasStartedAt();
  public interface ArtifactsNested<N> extends Nested<N>,ArtifactFluent<BuildStatusFluent.ArtifactsNested<N>>{
    public N and();
    public N endArtifact();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,BuildConditionFluent<BuildStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface FailureNested<N> extends Nested<N>,FailureFluent<BuildStatusFluent.FailureNested<N>>{
    public N and();
    public N endFailure();
    
  }
  
}