package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>> extends BaseFluent<A> implements BuildSpecFluent<A>{
  public BuildSpecFluentImpl() {
  }
  public BuildSpecFluentImpl(BuildSpec instance) {
    if (instance != null) {
      this.withStrategy(instance.getStrategy());
      this.withTasks(instance.getTasks());
      this.withTimeout(instance.getTimeout());
    }
  }
  private String strategy;
  private ArrayList<TaskBuilder> tasks = new ArrayList<TaskBuilder>();
  private Duration timeout;
  public String getStrategy() {
    return this.strategy;
  }
  public A withStrategy(String strategy) {
    this.strategy=strategy; return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  public A addToTasks(int index,Task item) {
    if (this.tasks == null) {this.tasks = new ArrayList<TaskBuilder>();}
    TaskBuilder builder = new TaskBuilder(item);
    if (index < 0 || index >= tasks.size()) { _visitables.get("tasks").add(builder); tasks.add(builder); } else { _visitables.get("tasks").add(index, builder); tasks.add(index, builder);}
    return (A)this;
  }
  public A setToTasks(int index,Task item) {
    if (this.tasks == null) {this.tasks = new ArrayList<TaskBuilder>();}
    TaskBuilder builder = new TaskBuilder(item);
    if (index < 0 || index >= tasks.size()) { _visitables.get("tasks").add(builder); tasks.add(builder); } else { _visitables.get("tasks").set(index, builder); tasks.set(index, builder);}
    return (A)this;
  }
  public A addToTasks(io.fabric8.camelk.v1.Task... items) {
    if (this.tasks == null) {this.tasks = new ArrayList<TaskBuilder>();}
    for (Task item : items) {TaskBuilder builder = new TaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
  }
  public A addAllToTasks(Collection<Task> items) {
    if (this.tasks == null) {this.tasks = new ArrayList<TaskBuilder>();}
    for (Task item : items) {TaskBuilder builder = new TaskBuilder(item);_visitables.get("tasks").add(builder);this.tasks.add(builder);} return (A)this;
  }
  public A removeFromTasks(io.fabric8.camelk.v1.Task... items) {
    for (Task item : items) {TaskBuilder builder = new TaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
  }
  public A removeAllFromTasks(Collection<Task> items) {
    for (Task item : items) {TaskBuilder builder = new TaskBuilder(item);_visitables.get("tasks").remove(builder);if (this.tasks != null) {this.tasks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTasks(Predicate<TaskBuilder> predicate) {
    if (tasks == null) return (A) this;
    final Iterator<TaskBuilder> each = tasks.iterator();
    final List visitables = _visitables.get("tasks");
    while (each.hasNext()) {
      TaskBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTasks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Task> getTasks() {
    return tasks != null ? build(tasks) : null;
  }
  public List<Task> buildTasks() {
    return tasks != null ? build(tasks) : null;
  }
  public Task buildTask(int index) {
    return this.tasks.get(index).build();
  }
  public Task buildFirstTask() {
    return this.tasks.get(0).build();
  }
  public Task buildLastTask() {
    return this.tasks.get(tasks.size() - 1).build();
  }
  public Task buildMatchingTask(Predicate<TaskBuilder> predicate) {
    for (TaskBuilder item: tasks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTask(Predicate<TaskBuilder> predicate) {
    for (TaskBuilder item: tasks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTasks(List<Task> tasks) {
    if (this.tasks != null) { _visitables.get("tasks").clear();}
    if (tasks != null) {this.tasks = new ArrayList(); for (Task item : tasks){this.addToTasks(item);}} else { this.tasks = null;} return (A) this;
  }
  public A withTasks(io.fabric8.camelk.v1.Task... tasks) {
    if (this.tasks != null) {this.tasks.clear(); _visitables.remove("tasks"); }
    if (tasks != null) {for (Task item :tasks){ this.addToTasks(item);}} return (A) this;
  }
  public Boolean hasTasks() {
    return tasks != null && !tasks.isEmpty();
  }
  public BuildSpecFluentImpl.TasksNested<A> addNewTask() {
    return new BuildSpecFluentImpl.TasksNestedImpl();
  }
  public BuildSpecFluentImpl.TasksNested<A> addNewTaskLike(Task item) {
    return new BuildSpecFluentImpl.TasksNestedImpl(-1, item);
  }
  public BuildSpecFluentImpl.TasksNested<A> setNewTaskLike(int index,Task item) {
    return new BuildSpecFluentImpl.TasksNestedImpl(index, item);
  }
  public BuildSpecFluentImpl.TasksNested<A> editTask(int index) {
    if (tasks.size() <= index) throw new RuntimeException("Can't edit tasks. Index exceeds size.");
    return setNewTaskLike(index, buildTask(index));
  }
  public BuildSpecFluentImpl.TasksNested<A> editFirstTask() {
    if (tasks.size() == 0) throw new RuntimeException("Can't edit first tasks. The list is empty.");
    return setNewTaskLike(0, buildTask(0));
  }
  public BuildSpecFluentImpl.TasksNested<A> editLastTask() {
    int index = tasks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tasks. The list is empty.");
    return setNewTaskLike(index, buildTask(index));
  }
  public BuildSpecFluentImpl.TasksNested<A> editMatchingTask(Predicate<TaskBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tasks.size();i++) { 
    if (predicate.test(tasks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tasks. No match found.");
    return setNewTaskLike(index, buildTask(index));
  }
  public Duration getTimeout() {
    return this.timeout;
  }
  public A withTimeout(Duration timeout) {
    this.timeout=timeout; return (A) this;
  }
  public Boolean hasTimeout() {
    return this.timeout != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildSpecFluentImpl that = (BuildSpecFluentImpl) o;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;

    if (!java.util.Objects.equals(tasks, that.tasks)) return false;

    if (!java.util.Objects.equals(timeout, that.timeout)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(strategy,  tasks,  timeout,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (tasks != null) { sb.append("tasks:"); sb.append(tasks + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  class TasksNestedImpl<N> extends TaskFluentImpl<BuildSpecFluentImpl.TasksNested<N>> implements BuildSpecFluentImpl.TasksNested<N>,Nested<N>{
    TasksNestedImpl(int index,Task item) {
      this.index = index;
      this.builder = new TaskBuilder(this, item);
    }
    TasksNestedImpl() {
      this.index = -1;
      this.builder = new TaskBuilder(this);
    }
    TaskBuilder builder;
    int index;
    public N and() {
      return (N) BuildSpecFluentImpl.this.setToTasks(index,builder.build());
    }
    public N endTask() {
      return and();
    }
    
  }
  
}