package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildConditionBuilder extends BuildConditionFluentImpl<BuildConditionBuilder> implements VisitableBuilder<BuildCondition,BuildConditionBuilder>{
  public BuildConditionBuilder() {
    this(false);
  }
  public BuildConditionBuilder(Boolean validationEnabled) {
    this(new BuildCondition(), validationEnabled);
  }
  public BuildConditionBuilder(BuildConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildConditionBuilder(BuildConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildCondition(), validationEnabled);
  }
  public BuildConditionBuilder(BuildConditionFluent<?> fluent,BuildCondition instance) {
    this(fluent, instance, false);
  }
  public BuildConditionBuilder(BuildConditionFluent<?> fluent,BuildCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildConditionBuilder(BuildCondition instance) {
    this(instance,false);
  }
  public BuildConditionBuilder(BuildCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildConditionFluent<?> fluent;
  Boolean validationEnabled;
  public BuildCondition build() {
    BuildCondition buildable = new BuildCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}